<?php
/**
 * Background Mask Style - Corner Paint.
 *
 * @package Divi
 * @sub-package Builder
 * @since 4.15.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}

/**
 * Class ET_Builder_Mask_Corner_Paint
 *
 * @since 4.15.0
 */
class ET_Builder_Mask_Corner_Paint extends ET_Builder_Background_Mask_Style_Base {
	/**
	 * Configuration.
	 *
	 * @return array
	 */
	public function settings() {
		return array(
			'label'      => esc_html__( 'Corner Paint', 'et-builder' ),
			'svgContent' => array(
				'default'          => array(
					'landscape' => '<path d="M1897.91,761c-108.84,85.71-243.64,272.72-358.87,364.85-40.53,32.41-117.39,145.61-144.5,95.37-3.43-6.34,24.11-14.4,32.15-27,35-54.92,15.21-52.52,12.43-114.64-1.41-31.46-22.88-49.87-22.77-79.55.07-20.86,41.76-26.62,53-45.1,22.5-37.08,107.59-113.32,64.62-118.8C1431,823,1480.73,897.9,1352.75,942.83c-53.09,18.63-40,31.2-98,48.18-34.22,10-47,100.9-78.38,85.7-12.52-6.07,12.86-20.41,17.93-30.87,6-12.49-32.49,1.7-30.35-12,4-25.89,77.29-74.23,43.54-70.2-32.32,3.86-114.09,121.48-114.2,68.3-.1-48.79,130.3-85.05,96-116.26-8.56-7.8-11.48-2.09-19.08-1.74-11.57.53-21.86,41.07-31.24,34.24-28.1-20.46,155.9-163.66,121.21-155.82-5.65,1.28-15.57,17.15-15.57,17.15-23.92-45.91,47.83-51,28.08-85.56-12.52-21.87-41-9.86-61.87,2.83-19.87,12.1-24.65,29.35-31.36,15.19-14.92-31.48-36.87-6.9-62.36,15.45-25.1,22,10.39-30.82,1.85-49.45C1080.56,624.06,986.93,826.3,928,832c-46.94,4.54-96,86-104.9,76.86C811,896.41,943.78,769.67,1005.49,701.3c131.22-145.4,45.54-66.26,5.73-128.07-36.22-56.23,15.29-51.41,39-130.93,3.66-12.28-1-14.57,13.89-30.63,17.26-18.62,47.88-6,61.16-16.41,8.17-6.39,7.57-2.21,16.7-11.43,6-6.07-1.5-9.42,2.64-12.8,13.09-10.67-16.84-16.73-16.26-27.15,2-36.37-13.94-62.73-18.2-108.42-3.28-35.22-23.88,5.36-36.64,7-98.25,13,11.51-167.61,73.21-201.1C1167.14,30.33,1186.17,16,1204.4,0H0V1440H1920V740.4C1910.13,750.29,1902.37,757.5,1897.91,761Zm-863.57,124.8c-12.16-1-5.62-.11-13.07,6.64-4.41,4-3.62,11.6-7.6,15.83-8.33,8.85,10.91-4.55,12.61,3.29.41,1.86-7,9.5-1.15,14.52.74.62-13.64,17.53-14.14,8.76-.53-9.27,14.1-10.35-2.27-13.81-10.47-2.21-13.63-18.41-19.2-26.83-2.81-4.25-9.8-3.31-11.62-8.55-1.12-3.25,24.57-4.22,3.91-10.89-17.72-5.72,3.31-8.25,4.42-21.82.74-8.94,7.45-7.39,9.77-16.11,5.59-21,42.49-52.28,57.87-37.65,19.35,18.41-1.13,5.82,6.14,17,1.93,3,4.72-5.63,7.55-4.46,1.61.66,1.07,5.89-.3,7C1055,828.37,1081,843,1080.2,849.2,1077.4,870.75,1052.74,887.38,1034.34,885.82Z"/>
									<path d="M1121.73,560.21c-22.33,29.93,34.74-16,26.41-28.13C1139.13,519,1126.83,553.37,1121.73,560.21Z"/>
									<path d="M1148.8,357.83c-.07.15.58.31.58.31C1149.67,357.86,1148.91,357.6,1148.8,357.83Z"/>',
					'portrait'  => '<path d="M1702.91,1301c-108.84,85.71-243.64,272.72-358.87,364.85-40.53,32.41-117.39,145.61-144.5,95.37-3.43-6.34,24.11-14.4,32.15-27,35-54.92,15.21-52.52,12.43-114.64-1.41-31.46-22.88-49.87-22.77-79.55.07-20.86,41.76-26.62,53-45.1,22.5-37.08,107.59-113.32,64.62-118.8-102.94-13.15-53.21,61.75-181.19,106.68-53.09,18.63-40,31.2-98,48.18-34.22,10-47,100.9-78.38,85.7-12.52-6.07,12.86-20.41,17.93-30.87,6-12.49-32.49,1.7-30.35-12,4-25.89,77.29-74.23,43.54-70.2-32.32,3.86-114.09,121.48-114.2,68.3-.1-48.79,130.3-85.05,96-116.26-8.56-7.8-11.48-2.09-19.08-1.74-11.57.53-21.86,41.07-31.24,34.24-28.1-20.46,155.9-163.66,121.21-155.82-5.65,1.28-15.57,17.15-15.57,17.15-23.92-45.91,47.83-51,28.08-85.56-12.52-21.87-41-9.86-61.87,2.83-19.87,12.1-24.65,29.35-31.36,15.19-14.92-31.48-36.87-6.9-62.36,15.45-25.1,22,10.39-30.82,1.85-49.45C885.56,1164.06,791.93,1366.3,733,1372c-46.94,4.54-96,86-104.9,76.86C616,1436.41,748.78,1309.67,810.49,1241.3c131.22-145.4,45.54-66.26,5.73-128.07-36.22-56.23,15.29-51.41,39-130.93,3.66-12.28-1-14.57,13.89-30.63,17.26-18.62,47.88-6,61.16-16.41,8.17-6.39,7.57-2.21,16.7-11.43,6-6.07-1.5-9.42,2.64-12.8,13.09-10.67-16.84-16.73-16.26-27.15,2-36.37-13.94-62.73-18.2-108.42-3.28-35.22-23.88,5.36-36.64,7-98.25,13,11.51-167.61,73.21-201.1C1024.39,542,1320.08,208.19,1528.74,0H0V2560H1920V1073.7C1806.44,1196.23,1713.5,1292.68,1702.91,1301Zm-863.57,124.8c-12.16-1-5.62-.11-13.07,6.64-4.41,4-3.62,11.6-7.6,15.83-8.33,8.85,10.91-4.55,12.61,3.29.41,1.86-7,9.5-1.15,14.52.74.62-13.64,17.53-14.14,8.76-.53-9.27,14.1-10.35-2.27-13.81-10.47-2.21-13.63-18.41-19.2-26.83-2.81-4.25-9.8-3.31-11.62-8.55-1.12-3.25,24.57-4.22,3.91-10.89-17.72-5.72,3.31-8.25,4.42-21.82.73-8.94,7.45-7.39,9.77-16.11,5.59-21,42.49-52.28,57.87-37.65,19.35,18.41-1.13,5.82,6.14,17,1.93,3,4.72-5.63,7.55-4.46,1.61.66,1.07,5.9-.3,7C860,1368.37,886,1383,885.2,1389.2,882.4,1410.75,857.74,1427.38,839.34,1425.82Z"/>
									<path d="M926.73,1100.21c-22.33,29.93,34.74-16,26.41-28.13C944.13,1059,931.83,1093.37,926.73,1100.21Z"/>
									<path d="M953.8,897.83c-.07.15.58.31.58.31C954.67,897.86,953.91,897.6,953.8,897.83Z"/>',
					'square'    => '<path d="M1811.91,966c-108.84,85.71-243.64,272.72-358.87,364.85-40.53,32.41-117.39,145.61-144.5,95.37-3.43-6.34,24.11-14.4,32.15-27,35-54.92,15.21-52.52,12.43-114.64-1.41-31.46-22.88-49.87-22.77-79.55.07-20.86,41.76-26.62,53-45.1,22.5-37.08,107.59-113.32,64.62-118.8-102.94-13.15-53.21,61.75-181.19,106.68-53.09,18.63-40,31.2-98,48.18-34.22,10-47,100.9-78.38,85.7-12.52-6.07,12.86-20.41,17.93-30.87,6-12.49-32.49,1.7-30.35-12,4-25.89,77.29-74.23,43.54-70.2-32.32,3.86-114.09,121.48-114.2,68.3-.1-48.79,130.3-85.05,96-116.26-8.56-7.8-11.48-2.09-19.08-1.74-11.57.53-21.86,41.07-31.24,34.24-28.1-20.46,155.9-163.66,121.21-155.82-5.65,1.28-15.57,17.15-15.57,17.15-23.92-45.91,47.83-51,28.08-85.56-12.52-21.87-41-9.86-61.87,2.83-19.87,12.1-24.65,29.35-31.36,15.19-14.92-31.48-36.87-6.9-62.36,15.45-25.1,22,10.39-30.82,1.85-49.45C994.56,829.06,900.93,1031.3,842,1037c-46.94,4.54-96,86-104.9,76.86C725,1101.41,857.78,974.67,919.49,906.3,1050.71,760.9,965,840,925.22,778.23,889,722,940.51,726.82,964.23,647.3c3.66-12.28-1-14.57,13.89-30.63,17.26-18.62,47.88-6,61.16-16.41,8.17-6.39,7.57-2.21,16.7-11.43,6-6.07-1.5-9.42,2.64-12.8,13.09-10.67-16.84-16.73-16.26-27.15,2-36.37-13.94-62.73-18.2-108.42-3.28-35.22-23.88,5.36-36.64,7.05-98.25,13,11.51-167.61,73.21-201.1,38.32-20.8,138.68-123.47,255.58-246.41H0V1920H1920V855.09C1860.47,917.94,1818.79,960.6,1811.91,966Zm-863.57,124.8c-12.16-1-5.62-.11-13.07,6.64-4.41,4-3.62,11.6-7.6,15.83-8.33,8.85,10.91-4.55,12.61,3.29.41,1.86-7,9.5-1.15,14.52.74.62-13.64,17.53-14.14,8.76-.53-9.27,14.1-10.35-2.27-13.81-10.47-2.21-13.63-18.41-19.2-26.83-2.81-4.25-9.8-3.31-11.62-8.55-1.12-3.25,24.57-4.22,3.91-10.89-17.72-5.72,3.31-8.25,4.42-21.82.74-8.94,7.45-7.39,9.77-16.11,5.59-21,42.49-52.28,57.87-37.65,19.35,18.41-1.13,5.82,6.14,17,1.93,3,4.72-5.63,7.55-4.46,1.61.66,1.07,5.89-.3,7C969,1033.37,995,1048,994.2,1054.2,991.4,1075.75,966.74,1092.38,948.34,1090.82Z"/>
									<path d="M1062.8,562.83c-.07.15.58.31.58.31C1063.67,562.86,1062.91,562.6,1062.8,562.83Z"/>
									<path d="M1035.73,765.21c-22.33,29.93,34.74-16,26.41-28.13C1053.13,724,1040.83,758.37,1035.73,765.21Z"/>',
				),
				'default-inverted' => array(
					'landscape' => '<path d="M1067.26,818.72c1.37-1.07,1.91-6.31.3-7-2.83-1.17-5.62,7.43-7.55,4.46-7.27-11.19,13.21,1.4-6.14-17-15.38-14.63-52.28,16.63-57.87,37.65-2.32,8.72-9,7.17-9.77,16.11-1.11,13.57-22.14,16.1-4.42,21.82,20.66,6.67-5,7.64-3.91,10.89,1.82,5.24,8.81,4.3,11.62,8.55,5.57,8.42,8.73,24.62,19.2,26.83,16.37,3.46,1.74,4.54,2.27,13.81.5,8.77,14.88-8.14,14.14-8.76-5.86-5,1.56-12.66,1.15-14.52-1.7-7.84-20.94,5.56-12.61-3.29,4-4.23,3.19-11.84,7.6-15.83,7.45-6.75.91-7.67,13.07-6.64,18.4,1.56,43.06-15.07,45.86-36.62C1081,843,1055,828.37,1067.26,818.72Z"/>
									<path d="M1204.4,0c-18.23,16-37.26,30.33-57.67,41.41-61.7,33.49-171.46,214.12-73.21,201.1,12.76-1.69,33.36-42.27,36.64-7,4.26,45.69,20.24,72,18.2,108.42-.58,10.42,29.35,16.48,16.26,27.15-4.14,3.38,3.37,6.73-2.64,12.8-9.13,9.22-8.53,5-16.7,11.43-13.28,10.4-43.9-2.21-61.16,16.41-14.9,16.06-10.23,18.35-13.89,30.63-23.72,79.52-75.23,74.7-39,130.93C1051,635,1136.71,555.9,1005.49,701.3,943.78,769.67,811,896.41,823.1,908.86,832,918,881.06,836.54,928,832c58.93-5.7,152.56-207.94,191-124.07,8.54,18.63-27,71.46-1.85,49.45,25.49-22.35,47.44-46.93,62.36-15.45,6.71,14.16,11.49-3.09,31.36-15.19,20.83-12.69,49.35-24.7,61.87-2.83,19.75,34.52-52,39.65-28.08,85.56,0,0,9.92-15.87,15.57-17.15,34.69-7.84-149.31,135.36-121.21,155.82,9.38,6.83,19.67-33.71,31.24-34.24,7.6-.35,10.52-6.06,19.08,1.74,34.27,31.21-96.13,67.47-96,116.26.11,53.18,81.88-64.44,114.2-68.3,33.75-4-39.52,44.31-43.54,70.2-2.14,13.74,36.39-.45,30.35,12-5.07,10.46-30.45,24.8-17.93,30.87,31.39,15.2,44.16-75.68,78.38-85.7,58-17,44.9-29.55,98-48.18,128-44.93,78.25-119.83,181.19-106.68,43,5.48-42.12,81.72-64.62,118.8-11.21,18.48-52.9,24.24-53,45.1-.11,29.68,21.36,48.09,22.77,79.55,2.78,62.12,22.57,59.72-12.43,114.64-8,12.6-35.58,20.66-32.15,27,27.11,50.24,104-63,144.5-95.37,115.23-92.13,250-279.14,358.87-364.85,4.46-3.52,12.22-10.73,22.09-20.62V0Zm-82.67,560.21c5.1-6.84,17.4-41.21,26.41-28.13C1156.47,544.17,1099.4,590.14,1121.73,560.21Zm27.65-202.07s-.65-.16-.58-.31S1149.67,357.86,1149.38,358.14Z"/>',
					'portrait'  => '<path d="M872.26,1358.72c1.37-1.07,1.91-6.31.3-7-2.83-1.17-5.62,7.43-7.55,4.46-7.27-11.19,13.21,1.4-6.14-17-15.38-14.63-52.28,16.63-57.87,37.65-2.32,8.72-9,7.17-9.77,16.11-1.11,13.57-22.14,16.1-4.42,21.82,20.66,6.67-5,7.64-3.91,10.89,1.82,5.24,8.81,4.3,11.62,8.55,5.57,8.42,8.73,24.62,19.2,26.83,16.37,3.46,1.74,4.54,2.27,13.81.5,8.77,14.88-8.14,14.14-8.76-5.86-5,1.56-12.66,1.15-14.52-1.7-7.84-20.94,5.56-12.61-3.29,4-4.23,3.19-11.84,7.6-15.83,7.45-6.75.91-7.67,13.07-6.64,18.4,1.56,43.06-15.07,45.86-36.62C886,1383,860,1368.37,872.26,1358.72Z"/>
									<path d="M1528.74,0c-208.66,208.19-504.35,542-577,581.41C890,614.9,780.27,795.53,878.52,782.51c12.76-1.69,33.36-42.27,36.64-7,4.26,45.69,20.24,72,18.2,108.42-.58,10.42,29.35,16.48,16.26,27.15-4.14,3.38,3.37,6.73-2.64,12.8-9.13,9.22-8.53,5-16.7,11.43-13.28,10.4-43.9-2.21-61.16,16.41-14.9,16.06-10.23,18.35-13.89,30.63-23.72,79.52-75.23,74.7-39,130.93C856,1175,941.71,1095.9,810.49,1241.3,748.78,1309.67,616,1436.41,628.1,1448.86c8.9,9.14,58-72.32,104.9-76.86,58.93-5.7,152.56-207.94,191-124.07,8.54,18.63-27,71.46-1.85,49.45,25.49-22.35,47.44-46.93,62.36-15.45,6.71,14.16,11.49-3.09,31.36-15.19,20.83-12.69,49.35-24.7,61.87-2.83,19.75,34.52-52,39.65-28.08,85.56,0,0,9.92-15.87,15.57-17.15,34.69-7.84-149.31,135.36-121.21,155.82,9.38,6.83,19.67-33.71,31.24-34.24,7.6-.35,10.52-6.06,19.08,1.74,34.27,31.21-96.13,67.47-96,116.26.11,53.18,81.88-64.44,114.2-68.3,33.75-4-39.52,44.31-43.54,70.2-2.14,13.74,36.39-.45,30.35,12-5.07,10.46-30.45,24.8-17.93,30.87,31.39,15.2,44.16-75.68,78.38-85.7,58-17,44.9-29.55,98-48.18,128-44.93,78.25-119.83,181.19-106.68,43,5.48-42.12,81.72-64.62,118.8-11.21,18.48-52.9,24.24-53,45.1-.11,29.68,21.36,48.09,22.77,79.55,2.78,62.12,22.57,59.72-12.43,114.64-8,12.6-35.58,20.66-32.15,27,27.11,50.24,104-63,144.5-95.37,115.23-92.13,250-279.14,358.87-364.85,10.59-8.34,103.53-104.79,217.09-227.32V0Zm-602,1100.21c5.1-6.84,17.4-41.21,26.41-28.13C961.47,1084.17,904.4,1130.14,926.73,1100.21Zm27.65-202.07s-.65-.16-.58-.31S954.67,897.86,954.38,898.14Z"/>',
					'square'    => '<path d="M981.26,1023.72c1.37-1.07,1.91-6.31.3-7-2.83-1.17-5.62,7.43-7.55,4.46-7.27-11.19,13.21,1.4-6.14-17-15.38-14.63-52.28,16.63-57.87,37.65-2.32,8.72-9,7.17-9.77,16.11-1.11,13.57-22.14,16.1-4.42,21.82,20.66,6.67-5,7.64-3.91,10.89,1.82,5.24,8.81,4.3,11.62,8.55,5.57,8.42,8.73,24.62,19.2,26.83,16.37,3.46,1.74,4.54,2.27,13.81.5,8.77,14.88-8.14,14.14-8.76-5.86-5,1.56-12.66,1.15-14.52-1.7-7.84-20.94,5.56-12.61-3.29,4-4.23,3.19-11.84,7.6-15.83,7.45-6.75.91-7.67,13.07-6.64,18.4,1.56,43.06-15.07,45.86-36.62C995,1048,969,1033.37,981.26,1023.72Z"/>
									<path d="M1316.31,0c-116.9,122.94-217.26,225.61-255.58,246.41C999,279.9,889.27,460.53,987.52,447.51c12.76-1.69,33.36-42.27,36.64-7.05,4.26,45.69,20.24,72.05,18.2,108.42-.58,10.42,29.35,16.48,16.26,27.15-4.14,3.38,3.37,6.73-2.64,12.8-9.13,9.22-8.53,5-16.7,11.43-13.28,10.4-43.9-2.21-61.16,16.41-14.9,16.06-10.23,18.35-13.89,30.63-23.72,79.52-75.23,74.7-39,130.93C965,840,1050.71,760.9,919.49,906.3,857.78,974.67,725,1101.41,737.1,1113.86c8.9,9.14,58-72.32,104.9-76.86,58.93-5.7,152.56-207.94,191-124.07,8.54,18.63-27,71.46-1.85,49.45,25.49-22.35,47.44-46.93,62.36-15.45,6.71,14.16,11.49-3.09,31.36-15.19,20.83-12.69,49.35-24.7,61.87-2.83,19.75,34.52-52,39.65-28.08,85.56,0,0,9.92-15.87,15.57-17.15,34.69-7.84-149.31,135.36-121.21,155.82,9.38,6.83,19.67-33.71,31.24-34.24,7.6-.35,10.52-6.06,19.08,1.74,34.27,31.21-96.13,67.47-96,116.26.11,53.18,81.88-64.44,114.2-68.3,33.75-4-39.52,44.31-43.54,70.2-2.14,13.74,36.39-.45,30.35,12-5.07,10.46-30.45,24.8-17.93,30.87,31.39,15.2,44.16-75.68,78.38-85.7,58-17,44.9-29.55,98-48.18,128-44.93,78.25-119.83,181.19-106.68,43,5.48-42.12,81.72-64.62,118.8-11.21,18.48-52.9,24.24-53,45.1-.11,29.68,21.36,48.09,22.77,79.55,2.78,62.12,22.57,59.72-12.43,114.64-8,12.6-35.58,20.66-32.15,27,27.11,50.24,104-63,144.5-95.37,115.23-92.13,250-279.14,358.87-364.85,6.88-5.43,48.56-48.08,108.09-110.93V0ZM1035.73,765.21c5.1-6.84,17.4-41.21,26.41-28.13C1070.47,749.17,1013.4,795.14,1035.73,765.21Zm27.65-202.07s-.65-.16-.58-.31S1063.67,562.86,1063.38,563.14Z"/>',
				),
				'rotated'          => array(
					'landscape' => '<path d="M761,22.09C846.73,130.93,1033.74,265.73,1125.87,381c32.41,40.53,145.61,117.39,95.37,144.5-6.34,3.43-14.4-24.11-27-32.15-54.92-35-52.52-15.21-114.64-12.43-31.46,1.41-49.87,22.88-79.55,22.77-20.86-.07-26.62-41.76-45.1-53-37.08-22.5-113.32-107.59-118.8-64.62C823,489,897.9,439.27,942.83,567.25c18.63,53.09,31.2,40,48.18,98,10,34.22,100.9,47,85.7,78.38-6.07,12.52-20.41-12.86-30.87-17.93-12.49-6,1.7,32.49-12,30.35-25.89-4-74.23-77.29-70.2-43.54,3.86,32.32,121.48,114.09,68.3,114.2-48.79.1-85.05-130.3-116.26-96-7.8,8.56-2.09,11.48-1.74,19.08.53,11.57,41.07,21.86,34.24,31.24-20.46,28.1-163.66-155.9-155.82-121.21,1.28,5.65,17.15,15.57,17.15,15.57-45.91,23.92-51-47.83-85.56-28.08-21.87,12.52-9.86,41,2.83,61.87,12.1,19.87,29.35,24.65,15.19,31.36-31.48,14.92-6.9,36.87,15.45,62.36,22,25.1-30.82-10.39-49.45-1.85C624.06,839.44,826.3,933.07,832,992c4.54,46.94,86,96,76.86,104.9C896.41,1109,769.67,976.22,701.3,914.51,555.9,783.29,635,869,573.23,908.78,517,945,521.82,893.49,442.3,869.77c-12.28-3.66-14.57,1-30.63-13.89-18.62-17.26-6-47.88-16.41-61.16-6.39-8.17-2.21-7.57-11.43-16.7-6.07-6-9.42,1.5-12.8-2.64-10.67-13.09-16.73,16.84-27.15,16.26-36.37-2-62.73,13.94-108.42,18.2-35.22,3.28,5.36,23.88,7,36.64,13,98.25-167.61-11.51-201.1-73.21C30.33,752.86,16,733.83,0,715.6V1440H1920V0H740.4C750.29,9.87,757.5,17.63,761,22.09Zm124.8,863.57c-1,12.16-.11,5.62,6.64,13.07,4,4.41,11.6,3.62,15.83,7.6,8.85,8.33-4.55-10.91,3.29-12.61,1.86-.41,9.5,7,14.52,1.15.62-.74,17.53,13.64,8.76,14.14-9.27.53-10.35-14.1-13.81,2.27-2.21,10.47-18.41,13.63-26.83,19.2-4.25,2.81-3.31,9.8-8.55,11.62-3.25,1.12-4.22-24.57-10.89-3.91-5.72,17.72-8.25-3.31-21.82-4.42-8.94-.74-7.39-7.45-16.11-9.77-21-5.59-52.28-42.49-37.65-57.87,18.41-19.35,5.82,1.13,17-6.14,3-1.93-5.63-4.72-4.46-7.55.66-1.61,5.89-1.07,7,.3C828.37,865,843,839,849.2,839.8,870.75,842.6,887.38,867.26,885.82,885.66ZM532.08,771.86c12.09-8.33,58.06,48.74,28.13,26.41C553.37,793.17,519,780.87,532.08,771.86Zm-173.94-1.24s-.16.65-.31.58S357.86,770.33,358.14,770.62Z"/>',
					'portrait'  => '<path d="M1009.41,113c89.56,113.73,285,254.58,381.25,375,33.86,42.36,152.15,122.67,99.65,151-6.62,3.58-15-25.2-28.21-33.59-57.39-36.58-54.89-15.9-119.79-13-32.88,1.47-52.12,23.9-83.13,23.79-21.79-.08-27.81-43.63-47.12-55.35-38.75-23.51-118.41-112.42-124.14-67.53-13.74,107.57,64.53,55.6,111.47,189.33,19.47,55.48,32.6,41.84,50.34,102.39,10.48,35.76,105.44,49.11,89.55,81.91C1333,880,1318,853.45,1307,848.16c-13-6.32,1.77,33.94-12.58,31.71-27-4.21-77.57-80.76-73.36-45.5,4,33.77,126.94,119.21,71.37,119.33-51,.1-88.87-136.15-121.48-100.34-8.14,8.94-2.18,12-1.82,19.93.56,12.1,42.92,22.85,35.79,32.65-21.38,29.36-171-162.91-162.83-126.66,1.34,5.91,17.92,16.27,17.92,16.27-48,25-53.33-50-89.4-29.34-22.86,13.08-10.3,42.88,3,64.65,12.64,20.76,30.67,25.76,15.87,32.77-32.9,15.59-7.21,38.52,16.15,65.16,23,26.23-32.21-10.85-51.68-1.93-87.64,40.15,123.69,138,129.64,199.57,4.75,49,89.87,100.31,80.31,109.61-13,12.66-145.43-126.1-216.88-190.58-151.93-137.12-69.23-47.59-133.82-6-58.76,37.84-53.72-16-136.81-40.76-12.84-3.83-15.23,1-32-14.52-19.45-18-6.28-50-17.14-63.91-6.68-8.54-2.31-7.9-12-17.45-6.34-6.28-9.84,1.57-13.37-2.76-11.16-13.67-17.49,17.6-28.37,17-38-2.13-65.55,14.57-113.29,19-36.81,3.43,5.6,25,7.37,38.29,13.6,102.67-175.14-12-210.14-76.5C235.74,857.83,128.46,753,0,630.81V2560H1920V0H893.51C959.18,62.2,1003.75,105.76,1009.41,113Zm130.41,902.36c-1.07,12.7-.11,5.88,6.94,13.66,4.17,4.6,12.12,3.77,16.54,7.94,9.25,8.7-4.75-11.4,3.44-13.18,1.94-.42,9.93,7.33,15.17,1.2.65-.77,18.32,14.26,9.15,14.78-9.69.55-10.81-14.74-14.43,2.37-2.31,10.94-19.24,14.24-28,20.06-4.45,2.94-3.46,10.24-8.93,12.14-3.4,1.18-4.41-25.67-11.38-4.08-6,18.51-8.62-3.46-22.8-4.62-9.35-.77-7.73-7.79-16.84-10.21-22-5.84-54.62-44.4-39.34-60.46,19.24-20.23,6.09,1.17,17.77-6.42,3.11-2-5.88-4.94-4.66-7.89.7-1.68,6.16-1.13,7.29.31,10.08,12.83,25.37-14.36,31.85-13.52C1124.07,970.31,1141.45,996.08,1139.82,1015.31ZM588.44,895.1s-.17.68-.33.61S588.14,894.8,588.44,895.1Zm181.75,1.3c12.64-8.7,60.67,50.92,29.39,27.59C792.44,918.66,756.52,905.81,770.19,896.4Z"/>',
					'square'    => '<path d="M966,108.09c85.71,108.84,272.72,243.64,364.85,358.87,32.41,40.53,145.61,117.39,95.37,144.5-6.34,3.43-14.4-24.11-27-32.15-54.92-35-52.52-15.21-114.64-12.43-31.46,1.41-49.87,22.88-79.55,22.77-20.86-.07-26.62-41.76-45.1-53-37.08-22.5-113.32-107.59-118.8-64.62C1028,575,1102.9,525.27,1147.83,653.25c18.63,53.09,31.2,40,48.18,98,10,34.22,100.9,47,85.7,78.38-6.07,12.52-20.41-12.86-30.87-17.93-12.49-6,1.7,32.49-12,30.35-25.89-4-74.23-77.29-70.2-43.54,3.86,32.32,121.48,114.09,68.3,114.2-48.79.1-85.05-130.3-116.26-96-7.8,8.56-2.09,11.48-1.74,19.08.53,11.57,41.07,21.86,34.24,31.24-20.46,28.1-163.66-155.9-155.82-121.21,1.28,5.65,17.15,15.57,17.15,15.57-45.91,23.92-51-47.83-85.56-28.08-21.87,12.52-9.86,41,2.83,61.87,12.1,19.87,29.35,24.65,15.19,31.36-31.48,14.92-6.9,36.87,15.45,62.36,22,25.1-30.82-10.39-49.45-1.85-83.87,38.43,118.37,132.06,124.07,191,4.54,46.94,86,96,76.86,104.9-12.45,12.12-139.19-120.68-207.56-182.39C760.9,869.29,840,955,778.23,994.78c-56.23,36.22-51.41-15.29-130.93-39-12.28-3.66-14.57,1-30.63-13.89-18.62-17.26-6-47.88-16.41-61.16-6.39-8.17-2.21-7.57-11.43-16.7-6.07-6-9.42,1.5-12.8-2.64-10.67-13.09-16.73,16.84-27.15,16.26-36.37-2-62.73,13.94-108.42,18.2-35.22,3.28,5.36,23.88,7.05,36.64,13,98.25-167.61-11.51-201.1-73.21C225.61,821,122.94,720.59,0,603.69V1920H1920V0H855.09C917.94,59.53,960.6,101.21,966,108.09Zm124.8,863.57c-1,12.16-.11,5.62,6.64,13.07,4,4.41,11.6,3.62,15.83,7.6,8.85,8.33-4.55-10.91,3.29-12.61,1.86-.41,9.5,7,14.52,1.15.62-.74,17.53,13.64,8.76,14.14-9.27.53-10.35-14.1-13.81,2.27-2.21,10.47-18.41,13.63-26.83,19.2-4.25,2.81-3.31,9.8-8.55,11.62-3.25,1.12-4.22-24.57-10.89-3.91-5.72,17.72-8.25-3.31-21.82-4.42-8.94-.74-7.39-7.45-16.11-9.77-21-5.59-52.28-42.49-37.65-57.87,18.41-19.35,5.82,1.13,17-6.14,3-1.93-5.63-4.72-4.46-7.55.66-1.61,5.89-1.07,7,.3C1033.37,951,1048,925,1054.2,925.8,1075.75,928.6,1092.38,953.26,1090.82,971.66Zm-527.68-115s-.16.65-.31.58S562.86,856.33,563.14,856.62Zm173.94,1.24c12.09-8.33,58.06,48.74,28.13,26.41C758.37,879.17,724,866.87,737.08,857.86Z"/>',
				),
				'rotated-inverted' => array(
					'landscape' => '<path d="M242.51,846.48c-1.69-12.76-42.27-33.36-7-36.64,45.69-4.26,72-20.24,108.42-18.2,10.42.58,16.48-29.35,27.15-16.26,3.38,4.14,6.73-3.37,12.8,2.64,9.22,9.13,5,8.53,11.43,16.7,10.4,13.28-2.21,43.9,16.41,61.16,16.06,14.9,18.35,10.23,30.63,13.89,79.52,23.72,74.7,75.23,130.93,39C635,869,555.9,783.29,701.3,914.51,769.67,976.22,896.41,1109,908.86,1096.9c9.14-8.9-72.32-58-76.86-104.9-5.7-58.93-207.94-152.56-124.07-191,18.63-8.54,71.46,27,49.45,1.85-22.35-25.49-46.93-47.44-15.45-62.36,14.16-6.71-3.09-11.49-15.19-31.36-12.69-20.83-24.7-49.35-2.83-61.87,34.52-19.75,39.65,52,85.56,28.08,0,0-15.87-9.92-17.15-15.57C784.48,625.09,927.68,809.09,948.14,781c6.83-9.38-33.71-19.67-34.24-31.24-.35-7.6-6.06-10.52,1.74-19.08,31.21-34.27,67.47,96.13,116.26,96,53.18-.11-64.44-81.88-68.3-114.2-4-33.75,44.31,39.52,70.2,43.54,13.74,2.14-.45-36.39,12-30.35,10.46,5.07,24.8,30.45,30.87,17.93,15.2-31.39-75.68-44.16-85.7-78.38-17-58-29.55-44.9-48.18-98C897.9,439.27,823,489,836.15,386.06c5.48-43,81.72,42.12,118.8,64.62,18.48,11.21,24.24,52.9,45.1,53,29.68.11,48.09-21.36,79.55-22.77,62.12-2.78,59.72-22.57,114.64,12.43,12.6,8,20.66,35.58,27,32.15,50.24-27.11-63-104-95.37-144.5C1033.74,265.73,846.73,130.93,761,22.09,757.5,17.63,750.29,9.87,740.4,0H0V715.6c16,18.23,30.33,37.26,41.41,57.67C74.9,835,255.53,944.73,242.51,846.48Zm289.57-74.62c12.09-8.33,58.06,48.74,28.13,26.41C553.37,793.17,519,780.87,532.08,771.86Zm-173.94-1.24s-.16.65-.31.58S357.86,770.33,358.14,770.62ZM934.86,909c-9.27.53-10.35-14.1-13.81,2.27-2.21,10.47-18.41,13.63-26.83,19.2-4.25,2.81-3.31,9.8-8.55,11.62-3.25,1.12-4.22-24.57-10.89-3.91-5.72,17.72-8.25-3.31-21.82-4.42-8.94-.74-7.39-7.45-16.11-9.77-21-5.59-52.28-42.49-37.65-57.87,18.41-19.35,5.82,1.13,17-6.14,3-1.93-5.63-4.72-4.46-7.55.66-1.61,5.89-1.07,7,.3C828.37,865,843,839,849.2,839.8c21.55,2.8,38.18,27.46,36.62,45.86-1,12.16-.11,5.62,6.64,13.07,4,4.41,11.6,3.62,15.83,7.6,8.85,8.33-4.55-10.91,3.29-12.61,1.86-.41,9.5,7,14.52,1.15C926.72,894.13,943.63,908.51,934.86,909Z"/>',
					'portrait'  => '<path d="M1191.06,1039.71c-9.69.55-10.81-14.74-14.43,2.37-2.31,10.94-19.24,14.24-28,20.06-4.45,2.94-3.46,10.24-8.93,12.14-3.4,1.18-4.41-25.67-11.38-4.08-6,18.51-8.62-3.46-22.8-4.62-9.35-.77-7.73-7.79-16.84-10.21-22-5.84-54.62-44.4-39.34-60.46,19.24-20.23,6.09,1.17,17.77-6.42,3.11-2-5.88-4.94-4.66-7.89.7-1.68,6.16-1.13,7.29.31,10.08,12.83,25.37-14.36,31.85-13.52,22.51,2.92,39.89,28.69,38.26,47.92-1.07,12.7-.11,5.88,6.94,13.66,4.17,4.6,12.12,3.77,16.54,7.94,9.25,8.7-4.75-11.4,3.44-13.18,1.94-.42,9.93,7.33,15.17,1.2C1182.56,1024.16,1200.23,1039.19,1191.06,1039.71ZM0,630.81V0H893.51c65.67,62.2,110.24,105.76,115.9,113,89.56,113.73,285,254.58,381.25,375,33.86,42.36,152.15,122.67,99.65,151-6.62,3.58-15-25.2-28.21-33.59-57.39-36.58-54.89-15.9-119.79-13-32.88,1.47-52.12,23.9-83.13,23.79-21.79-.08-27.81-43.63-47.12-55.35-38.75-23.52-118.41-112.42-124.14-67.53-13.74,107.57,64.53,55.6,111.47,189.33,19.47,55.48,32.6,41.84,50.34,102.39,10.48,35.76,105.44,49.11,89.55,81.91C1333,880,1318,853.45,1307,848.16c-13-6.32,1.77,33.94-12.58,31.71-27-4.21-77.57-80.76-73.36-45.5,4,33.77,126.94,119.21,71.37,119.33-51,.1-88.87-136.15-121.48-100.34-8.14,8.94-2.18,12-1.82,19.93.56,12.1,42.92,22.85,35.79,32.65-21.38,29.36-171-162.91-162.83-126.66,1.34,5.91,17.92,16.27,17.92,16.27-48,25-53.33-50-89.4-29.34-22.86,13.08-10.3,42.88,3,64.65,12.64,20.76,30.67,25.76,15.87,32.77-32.9,15.59-7.21,38.52,16.15,65.16,23,26.23-32.21-10.85-51.68-1.93-87.64,40.16,123.69,138,129.64,199.57,4.75,49,89.87,100.31,80.31,109.61-13,12.66-145.43-126.1-216.88-190.58-151.93-137.12-69.23-47.59-133.82-6-58.76,37.84-53.72-16-136.81-40.76-12.84-3.83-15.23,1-32-14.52-19.45-18-6.28-50-17.14-63.91-6.68-8.54-2.31-7.9-11.94-17.45-6.35-6.28-9.85,1.57-13.38-2.76-11.16-13.67-17.49,17.6-28.37,17-38-2.13-65.55,14.57-113.29,19-36.81,3.43,5.6,25,7.37,38.29,13.6,102.67-175.14-12-210.14-76.5C235.74,857.83,128.46,753,0,630.81ZM799.58,924c31.28,23.33-16.75-36.29-29.39-27.59C756.52,905.81,792.44,918.66,799.58,924ZM588.11,895.71c.16.07.33-.61.33-.61C588.14,894.8,587.87,895.6,588.11,895.71Z"/>',
					'square'    => '<path d="M1139.86,995c-9.27.53-10.35-14.1-13.81,2.27-2.21,10.47-18.41,13.63-26.83,19.2-4.25,2.81-3.31,9.8-8.55,11.62-3.25,1.12-4.22-24.57-10.89-3.91-5.72,17.72-8.25-3.31-21.82-4.42-8.94-.74-7.39-7.45-16.11-9.77-21-5.59-52.28-42.49-37.65-57.87,18.41-19.35,5.82,1.13,17-6.14,3-1.93-5.63-4.72-4.46-7.55.66-1.61,5.9-1.07,7,.3C1033.37,951,1048,925,1054.2,925.8c21.55,2.8,38.18,27.46,36.62,45.86-1,12.16-.11,5.62,6.64,13.07,4,4.41,11.6,3.62,15.83,7.6,8.85,8.33-4.55-10.91,3.29-12.61,1.86-.41,9.5,7,14.52,1.15C1131.72,980.13,1148.63,994.51,1139.86,995ZM0,603.69V0H855.09C917.94,59.53,960.59,101.21,966,108.09c85.71,108.84,272.72,243.64,364.85,358.87,32.41,40.53,145.61,117.39,95.37,144.5-6.34,3.43-14.4-24.11-27-32.15-54.92-35-52.52-15.21-114.64-12.43-31.46,1.41-49.87,22.88-79.55,22.77-20.86-.07-26.62-41.76-45.1-53-37.08-22.5-113.32-107.59-118.8-64.62C1028,575,1102.9,525.27,1147.83,653.25c18.63,53.09,31.2,40,48.18,98,10,34.22,100.9,47,85.7,78.38-6.07,12.52-20.41-12.86-30.87-17.93-12.49-6,1.7,32.49-12,30.35-25.89-4-74.23-77.29-70.2-43.54,3.86,32.32,121.48,114.09,68.3,114.2-48.79.1-85.05-130.3-116.26-96-7.8,8.56-2.09,11.48-1.74,19.08.53,11.57,41.07,21.86,34.24,31.24-20.46,28.1-163.66-155.9-155.82-121.21,1.28,5.65,17.15,15.57,17.15,15.57-45.91,23.92-51-47.83-85.56-28.08-21.87,12.52-9.86,41,2.83,61.87,12.1,19.87,29.35,24.65,15.19,31.36-31.48,14.92-6.9,36.87,15.45,62.36,22,25.1-30.82-10.39-49.45-1.85-83.87,38.43,118.37,132.06,124.07,191,4.54,46.94,86,96,76.86,104.9-12.45,12.12-139.19-120.68-207.56-182.39C760.9,869.29,840,955,778.23,994.78c-56.23,36.22-51.41-15.29-130.93-39-12.28-3.66-14.57,1-30.63-13.89-18.62-17.26-6-47.88-16.41-61.16-6.39-8.17-2.21-7.57-11.43-16.7-6.07-6-9.42,1.5-12.8-2.64-10.67-13.09-16.73,16.84-27.15,16.26-36.37-2-62.73,13.94-108.42,18.2-35.22,3.28,5.36,23.88,7.05,36.64,13,98.25-167.61-11.51-201.1-73.21C225.61,821,122.94,720.59,0,603.69ZM765.21,884.27c29.93,22.33-16-34.74-28.13-26.41C724,866.87,758.37,879.17,765.21,884.27ZM562.83,857.2c.15.07.31-.58.31-.58C562.86,856.33,562.6,857.09,562.83,857.2Z"/>',
				),
			),
		);
	}
}

return new ET_Builder_Mask_Corner_Paint();
