<?php

	class DiviBars_Helper extends DiviBars {
		
		public function __construct() {
			
		}
		
		public static function get_all_wordpress_menus(){
			return get_terms( 'nav_menu', array( 'hide_empty' => true ) ); 
		}
		
		
		public static function prepareBars( $key = NULL )
		{
			try {
				
				if ( !$key ) {
					
					throw new InvalidArgumentException( 'DiviBars_Helper::prepareBars > Required var $key');
					
				}
				
				// it is an url with hash divibars?
				if ( strpos( $key, "#divibars-" ) !== false ) {
					
					$exploded_url = explode( "#", $key );
					
					if ( isset( $exploded_url[1] ) ) {
						
						$key = str_replace( 'divibars-', '', $exploded_url[1] );
						
						return $key;
					}
				}
				
				$pos = strpos( $key, 'divibars-' );
				if ( $pos !== false ) {
					
					$key = substr( $key, $pos );
					$key = preg_replace( '/[^0-9.]/', '', $key );
				}
				else {
					
					return NULL;
				}
				
				if ( $key == '' ) {
					return NULL;
				}
				
				if ( !self::barIsPublished( $key ) ) {
					
					return NULL;
				}
				
				return $key;
				
			} catch (Exception $e) {
				
				DiviBars::log( $e );
				
				return NULL;
			}
		}
		
		
		public static function searchForDiviBars( $content = NULL ) {
			
			$divibars_in_content = array();
			
			try {
				
				if ( !$content ) {
					
					throw new InvalidArgumentException( 'DiviBars_Helper::searchForDiviBars > Required var $content');
				}
				
				$matches = array();
				$pattern = '/id="(.*?divibars_[0-9]+)"/';
				preg_match_all( $pattern, $content, $matches );
				
				$divibars_divibar_ = $matches[1];
				
				$matches = array();
				$pattern = '/id="(.*?divibars_unique_id_[0-9]+)"/';
				preg_match_all( $pattern, $content, $matches );
				
				$divibars_divibar_unique_id_ = $matches[1];
				
				$matches = array();
				$pattern = '/id="(.*?unique_divibars_menu_id_[0-9]+)"/';
				preg_match_all( $pattern, $content, $matches );
				
				$divibars_divibar_unique_divibars_menu_id_ = $matches[1];
				
				$matches = array();
				$pattern = '/(\S+)class=["\']?((?:.divibar\-[0-9]+(?!["\']?\s+(?:\S+)=|[>"\']))+.)["\']?/';
				preg_match_all($pattern, $content, $matches);
				
				$divibars_class_divibar = $matches[2];
				
				$matches = array();
				$pattern = '/.*class\s*=\s*["\'].*divibar\-[0-9]+/';
				preg_match_all($pattern, $content, $matches);
				
				$divibars_class_divibar_2 = $matches[0];
				
				$matches = array();
				$pattern = '/(?=<[^>]+(?=[\s+\"\']divibar\-[0-9]+[\s+\"\']).+)([^>]+>)/';
				preg_match_all($pattern, $content, $matches);
				
				$divibars_onanyattr = $matches[0];
				
				
				$divibars_found = $divibars_divibar_ + $divibars_divibar_unique_id_ + $divibars_divibar_unique_divibars_menu_id_ + $divibars_class_divibar + $divibars_class_divibar_2 + $divibars_onanyattr;
				
				if ( is_array( $divibars_found ) && count( $divibars_found ) > 0 ) {
					
					$divibars_in_content = array_flip( array_filter( array_map( 'self::prepareBars', $divibars_found ) ) );
				}
				
			} catch (Exception $e) {
			
				DiviBars::log( $e );
				
				return $divibars_in_content;
			}
				
			return $divibars_in_content;
		}
		
		
		public static function searchForDiviBarsInPost( $post = NULL, $avoidRenderTags = 0 ) {
			
			$divibars_in_post = array();
			
			try {
				
				if ( !$post ) {
					
					throw new InvalidArgumentException( 'DiviBars_Helper::searchForDiviBarsInPost > Required var $post');
				}
				
				if ( ! isset( $post->ID ) ) {
					
					throw new InvalidArgumentException( 'DiviBars_Helper::searchForDiviBarsInPost > Couldn\'t found property $post->ID');
				}
				
				$post_content = DiviBars_Controller::getRender( $post->ID, $avoidRenderTags );
				
				if ( !$post_content ) {
					
					throw new InvalidArgumentException( 'DiviBars_Helper::searchForDiviBarsInPost > Post ID: ' . $post->ID . ' Not found');
				}
				
				$post_content = $post_content['output'];
				
				$divibars_in_post = self::searchForDiviBars( $post_content );
				
			} catch (Exception $e) {
			
				DiviBars::log( $e );
				
				return $divibars_in_post;
			}
			
			return $divibars_in_post;
		}
		
		private static function barIsPublished( $key ) {
			
			try {
			
				$post = get_post_status( $key );
			
			} catch (Exception $e) {
			
				DiviBars::log( $e );
				
				return FALSE;
			}
			
			if ( $post != 'publish' ) {
				
				return FALSE;
			}
			
			return TRUE;
		}
		
		
		// Fastest way to check if a string is JSON
		public static function isJson($string) {
		
			json_decode($string);
			
			return ( json_last_error() == JSON_ERROR_NONE );
		}
		
		
		public static function convertDateToUTC( $date = null, $timezone = DIVI_SERVER_TIMEZONE, $format = DIVI_SCHEDULING_DATETIME_FORMAT ) {
			
			if ( $date === null ) {
				
				return;
			}
			
			if ( !self::validateDate( $date, $format ) ) {
				
				return;
			}
			
			$str_server_now = '';
			
			try {
			
				$timezone = wp_timezone();
				
				$date = new DateTime( $date, $timezone );
				$str_server_now = $date->format( $format );
				
			} catch (Exception $e) {
			
				DiviBars::log( $e );
				
				return FALSE;
			}
			
			return $str_server_now;
		}
		
		
		public static function convertDateToUserTimezone( $date = null, $format = DIVI_SCHEDULING_DATETIME_FORMAT ) {
			
			if ( $date === null ) {
				
				return;
			}
			
			if ( !self::validateDate( $date, $format ) ) {
				
				return;
			}
			
			$str_server_now = '';
			
			try {
			
				$timezone = wp_timezone();
				
				$date = new DateTime( $date, $timezone );
				$str_server_now = $date->format( $format );
			
			} catch (Exception $e) {
			
				DiviBars::log( $e );
				
				return FALSE;
			}
			
			return $str_server_now;
		}
		
		
		public static function validateDate( $dateStr, $format ) {
			
			$date = DateTime::createFromFormat($format, $dateStr);
			
			return $date && ($date->format($format) === $dateStr);
		}
		
		
		public static function getDiviStylesManager() {
			
			if ( wp_doing_ajax() || wp_doing_cron() || ( is_admin() && ! is_customize_preview() ) ) {
				return;
			}

			/** @see ET_Core_SupportCenter::toggle_safe_mode */
			if ( et_core_is_safe_mode_active() ) {
				return;
			}
			
			$all_resources = ET_Core_PageResource::get_resources();
			
			$enqueued_resources = array();
			
			foreach( $all_resources as $resource ) {
				
				if ( $resource->enqueued === true ) {
					
					$enqueued_resources[] = $resource;
				}
			}
			
			return $enqueued_resources;
		}
		
		
		public static function avoidRenderTags( $content = NULL, $restore = false ) {
			
			if ( !$content ) {
				
				return '';
			}
			
			try {
				
				if ( !$restore ) {
					
					$content = str_replace( '[et_pb_video', '[et_pb_video_divibarstemp', $content );
					$content = str_replace( '[/et_pb_video]', '[/et_pb_video_divibarstemp]', $content );
					
					$content = str_replace( '[et_pb_contact_form', '[et_pb_contact_form_divibarstemp', $content );
					$content = str_replace( '[/et_pb_contact_form]', '[/et_pb_contact_form_divibarstemp]', $content );
					
					$content = str_replace( '[woocommerce_checkout]', '[woocommerce_checkout_divibarstemp]', $content );
					$content = str_replace( '[et_pb_wc_add_to_cart', '[et_pb_wc_add_to_cart_divibarstemp]', $content );
					
					$content = str_replace( '[ultimatemember', '[ultimatemember_divibarstemp]', $content );
				
				} else {
					
					$content = str_replace( '[et_pb_video_divibarstemp', '[et_pb_video', $content );
					$content = str_replace( '[/et_pb_video_divibarstemp]', '[/et_pb_video]', $content );
					
					$content = str_replace( '[et_pb_contact_form_divibarstemp', '[et_pb_contact_form', $content );
					$content = str_replace( '[/et_pb_contact_form_divibarstemp]', '[/et_pb_contact_form]', $content );
					
					$content = str_replace( '[woocommerce_checkout_divibarstemp]', '[woocommerce_checkout]', $content );
					$content = str_replace( '[et_pb_wc_add_to_cart_divibarstemp', '[et_pb_wc_add_to_cart]', $content );
					
					$content = str_replace( '[ultimatemember_divibarstemp', '[ultimatemember]', $content );
				}
			
			} catch ( Exception $e ) {
			
				DiviOverlays::log( $e );
			}
			
			return $content;
		}
	}
	
	