<?php

	class DiviBars_Controller extends DiviBars {
		
		protected static $_show_errors = FALSE;
		
		/**
		 * @var \WP_Filesystem_Base|null
		 */
		public static $wpfs;
		
		/**
		 * @var ET_Core_Data_Utils
		 */
		public static $data_utils;
		
		private static $slug = 'DiviBars-divi-custom-styles';
		
		private static $post_id;
		
		private static $filename;
		
		private static $file_extension;
		
		private static $cache_dir;
		
		private static $module_index = - 1;
		
		public function __construct() {
			
		}
		
		
		public static function addDiviBars( $the_content, $render = true ) {
			
			if ( !class_exists( 'DiviExtension' ) ) {
				
				return;
			}
			
			self::$helper = new DiviBars_Helper;
			
			$divibars_in_current = array();
			
			try {
				
				// phpcs:ignore WordPress.Security.NonceVerification.Recommended
				if ( isset( $_GET['et_fb'] ) && $render ) {
					
					// phpcs:ignore WordPress.Security.NonceVerification.Recommended
					$divi_builder_enabled = sanitize_text_field( wp_unslash( $_GET['et_fb'] ) );
					
					// is divi theme builder ?
					if ( $divi_builder_enabled === '1' ) {
						
						return;
					}
				}
				
				if ( $render ) {
					
					$the_content = $the_content . '<div id="sidebar-divibar" class="hiddenMainDiviBarsContainer">';
				}
				
				
				/* Add Global Settings */
				if ( $render ) {
				
					print '<script type="text/javascript">var divibars_settings = {';
					
					$divibars_settings = get_option( 'dib_settings' );
					if ( isset( $divibars_settings['dib_custom_elems'] ) ) {
						
						print '\'dib_custom_elems\': \'' . et_core_esc_previously( $divibars_settings['dib_custom_elems'] ) . '\',';
					}
					
					print '};</script>';
				}
				
				/* Search CSS Triggers in all Divi divibars */
				$divibars_with_css_trigger = array();
				
				$dwct_posts = '';
				if ( isset( DiviBars::$divibarsList['divibars_with_css_trigger'] ) ) {
					
					$dwct_posts = DiviBars::$divibarsList['divibars_with_css_trigger'];
				}
				
				if ( !empty( $dwct_posts ) && $render ) {
					
					print '<script type="text/javascript">var divibars_with_css_trigger = {';
					
					foreach( $dwct_posts as $post_id => $css_selector ) {
						
						print '\'' . et_core_esc_previously( $post_id ) . '\': \'' . et_core_esc_previously( $css_selector ) . '\',';
					}
					
					print '};</script>';
				}
				
				
				/* Search Divi divibars with Custom Close Buttons */
				if ( $render ) {
					
					$dccb_posts = DiviBars_Model::getDivibars('customizeclosebtn');
					if ( !empty( $dccb_posts ) ) {
						
						print '<style type="text/css">';
						
						foreach( $dccb_posts as $dv_post ) {
							
							$post_id = $dv_post->ID;
							
							$cbc_textcolor = get_post_meta( $post_id, 'post_closebtn_text_color', true );
							$cbc_bgcolor = get_post_meta( $post_id, 'post_closebtn_bg_color', true );
							$cbc_fontsize = get_post_meta( $post_id, 'post_closebtn_fontsize', true );
							$cbc_borderradius = get_post_meta( $post_id, 'post_closebtn_borderradius', true );
							$cbc_padding = get_post_meta( $post_id, 'post_closebtn_padding', true );
							
							$customizeclosebtn = get_post_meta( $post_id, 'post_do_customizeclosebtn' );
							if ( isset( $customizeclosebtn[0] ) ) {
								
								$customizeclosebtn = $customizeclosebtn[0];
								
							} else {
								
								continue;
							}
							
							if ( $customizeclosebtn ) {
								
								print '
								.divibar-customclose-btn-' . et_core_esc_previously( $post_id ) . ' {
									top:5px !important;
									color:' . esc_attr( $cbc_textcolor ) . ' !important;
									background-color:' . esc_attr( $cbc_bgcolor ) . ' !important;
									font-size:' . esc_attr( $cbc_fontsize ) . 'px !important;
									padding:' . esc_attr( $cbc_padding ) . 'px !important;
									-moz-border-radius:' . esc_attr( $cbc_borderradius ) . '% !important;
									-webkit-border-radius:' . esc_attr( $cbc_borderradius ) . '% !important;
									-khtml-border-radius:' . esc_attr( $cbc_borderradius ) . '% !important;
									border-radius:' . esc_attr( $cbc_borderradius ) . '% !important;
								}
								';
							}
						}
						
						print '</style>';
					}
				}
				
				
				/* Search Automatic Triggers in all Divi divibars */
				if ( isset( DiviBars::$divibarsList['divibars_with_automatic_trigger'] ) ) {
					
					$dwat_posts = DiviBars::$divibarsList['divibars_with_automatic_trigger'];
					if ( !empty( $dwat_posts ) && $render ) {
						
						print '<script type="text/javascript">var divibars_with_automatic_trigger = {';
						
						foreach( $dwat_posts as $post_id => $at_settings ) {
							
							print '\'' . et_core_esc_previously( $post_id ) . '\': \'' . et_core_esc_previously( $at_settings ) . '\',';
						}
						
						print '};</script>';
					}
				}
				
				
				$divibars = '';
				if ( isset( DiviBars::$divibarsList['ids'] ) ) {
					
					$divibars = DiviBars::$divibarsList['ids'];
				}
				
				if ( is_array( $divibars ) && count( $divibars ) > 0 ) {
					
					global $post;
					
					$ref_id = 0;
					
					$current_post_id = 0;
					
					if ( function_exists( 'get_queried_object_id' ) && get_queried_object_id() > 0 ) {
						
						$current_post_id = get_queried_object_id();
					
					} else {
					
						$current_home_post_id = (int) get_option( 'page_on_front' );
						
						$is_home = is_home();
						
						if ( $current_home_post_id == 0 && !$is_home ) {
							
							$current_post_id = get_the_ID();
						}
					}
					
		
					if ( is_category() ) {
						
						$current_category_id = (int) get_queried_object_id();
					}
					else {
						
						$current_category_id = 0;
					}
					
					if ( is_tag() ) {
						
						$current_tag_id = (int) get_queried_object_id();
					}
					else {
						
						$current_tag_id = 0;
					}
					
					// Get reference for divibar Divi styles
					if ( $current_post_id > 0 ) {
						
						$ref_id = $current_post_id;
					}
					else if ( $current_category_id > 0 ) {
						
						$ref_id = $current_category_id;
					}
					else if ( $current_tag_id > 0 ) {
						
						$ref_id = $current_tag_id;
					}
					
					$post_id = $current_post_id;
					$is_preview          = is_preview() || is_et_pb_preview();
					$forced_in_footer    = $post_id && et_builder_setting_is_on( 'et_pb_css_in_footer', $post_id );
					$forced_inline       = ! $post_id || $is_preview || $forced_in_footer || et_builder_setting_is_off( 'et_pb_static_css_file', $post_id ) || et_core_is_safe_mode_active() || ET_GB_Block_Layout::is_layout_block_preview();
					
					foreach( $divibars as $divibar_id => $idx ) {
						
						$display_in_current = false;
						
						$forcerender = get_post_meta( $divibar_id, 'divibars_displaylocations_forcerender' );
						
						if ( isset( $forcerender[0] ) && $forcerender[0] == '1' ) {
							
							$forcerender = true;
							
						} else {
							
							$forcerender = false;
						}
						
						if ( get_post_status ( $divibar_id ) == 'publish' ) {
							
							$divibars_showguests = get_post_meta( $divibar_id, 'divibars_showguests', true );
							
							if ( isset( $divibars_showguests[0] ) ) {
								
								$divibars_showguests = (int) $divibars_showguests[0];
								
							} else {
								
								$divibars_showguests = 0;
							}
							
							$divibars_showusers = get_post_meta( $divibar_id, 'divibars_showusers', true );
							
							if ( isset( $divibars_showusers[0] ) ) {
								
								$divibars_showusers = (int) $divibars_showusers[0];
								
							} else {
								
								$divibars_showusers = 0;
							}
							
							if ( $divibars_showguests === 1 && is_user_logged_in() === true && $divibars_showusers === 0 ) {
								
								continue;
							}
							
							if ( $divibars_showusers === 1 && is_user_logged_in() === false && $divibars_showguests === 0 ) {
								
								continue;
							}
							
							
							$display_on_archive = get_post_meta( $divibar_id, 'divibars_displaylocations_archive', true );
							
							if ( isset( $display_on_archive[0] ) ) {
								
								$display_on_archive = (int) $display_on_archive[0];
								
							} else {
								
								$display_on_archive = 1;
							}
							
							
							$display_on_author = get_post_meta( $divibar_id, 'divibars_displaylocations_author', true );
							
							if ( isset( $display_on_author[0] ) ) {
								
								$display_on_author = (int) $display_on_author[0];
								
							} else {
								
								$display_on_author = 1;
							}
							
							
							// Check for WooCommerce page
							$is_woocommerce = false;
							if ( function_exists( 'wc_get_page_id' ) ) {
								
								if ( ! is_front_page() && is_woocommerce() ) {
									
									$is_woocommerce = true;
									
									$shop_page_id = wc_get_page_id( 'shop' );
									
									if ( is_shop() && ! ( is_post_type_archive() && intval( get_option( 'page_on_front' ) ) === $shop_page_id ) ) {
										
										$current_post_id = $shop_page_id;
									}
								}
							}
							
							// Check WPML
							if ( defined( 'WCML_VERSION' ) || defined( 'ICL_SITEPRESS_VERSION') ) {
								
								$current_site_lang = apply_filters( 'wpml_current_language', NULL );
								
								$post_language_details = apply_filters( 'wpml_post_language_details', '', $divibar_id );
								
								if ( isset( $post_language_details[ 'language_code' ] ) ) {
									
									if ( $post_language_details[ 'language_code' ] !== $current_site_lang ) {
										
										continue;
									}
								}
							}
							
						
							$at_pages = get_post_meta( $divibar_id, 'at_pages' );
							$display_in_posts = ( !isset( $at_pages[0] ) ) ? 'all' : $at_pages[0];
							
							if ( ( is_home() || is_page() || is_single() ) 
								|| ( $is_woocommerce && $current_post_id > 0 ) ) {
							
								$at_pages = get_post_meta( $divibar_id, 'do_at_pages' );
								
								if ( $display_in_posts == 'specific' ) {
									
									$display_in_current = false;
									
									$in_posts = array_filter( get_post_meta( $divibar_id, 'at_pages_selected' ) );
									
									if ( isset ( $in_posts[0] ) && $in_posts[0] != '' ) {
										
										foreach( $in_posts[0] as $in_post => $the_id ) {
											
											if ( $the_id == $current_post_id ) {
												
												$display_in_current = true;
												
												break;
											}
										}
									}
								}
								
								if ( $display_in_posts == 'all' ) {
									
									$display_in_current = true;
									
									$except_in_posts = array_filter( get_post_meta( $divibar_id, 'at_pagesexception_selected' ) );
									
									if ( isset ( $except_in_posts[0] ) && $except_in_posts[0] != '' ) {
										
										foreach( $except_in_posts[0] as $in_post => $the_id ) {
											
											if ( $the_id == $current_post_id ) {
												
												$display_in_current = false;
												
												break;
											}
										}
									}
								}
							}
							
							// Display By Category
							if ( is_category() ) {
								
								$category_at_categories = get_post_meta( $divibar_id, 'divibars_category_at_categories' );
								
								$display_in_categories = ( !isset( $category_at_categories[0] ) ) ? 'all' : $category_at_categories[0];
								
								if ( $display_in_categories == 'specific' ) {
									
									$display_in_current = false;
									
									$in_categories = get_post_meta( $divibar_id, 'divibars_category_at_categories_selected' );
									
									if ( isset ( $in_categories[0] ) && $in_categories[0] != '' ) {
										
										foreach( $in_categories[0] as $in_category => $the_id ) {
											
											if ( $the_id == $current_category_id ) {
												
												$display_in_current = true;
												
												break;
											}
										}
									}
								}
								
								if ( $display_in_categories == 'all' ) {
									
									$display_in_current = true;
									
									$except_in_categories = get_post_meta( $divibar_id, 'divibars_category_at_exceptioncategories_selected' );
									
									if ( isset ( $except_in_categories[0] ) && $except_in_categories[0] != '' ) {
										
										foreach( $except_in_categories[0] as $in_category => $the_id ) {
											
											if ( $the_id == $current_category_id ) {
												
												$display_in_current = false;
												
												break;
											}
										}
									}
								}
							}
							
							// Display By Tag
							if ( is_tag() ) {
								
								$tag_at_tags = get_post_meta( $divibar_id, 'divibars_tag_at_tags' );
								
								$display_in_tags = ( !isset( $tag_at_tags[0] ) ) ? 'all' : $tag_at_tags[0];
								
								if ( $display_in_tags == 'specific' ) {
									
									$display_in_current = false;
									
									$in_tags = get_post_meta( $divibar_id, 'divibars_tag_at_tags_selected' );
									
									if ( isset ( $in_tags[0] ) && $in_tags[0] != '' ) {
										
										foreach( $in_tags[0] as $in_tag => $the_id ) {
											
											if ( $the_id == $current_tag_id ) {
												
												$display_in_current = true;
												
												break;
											}
										}
									}
								}
								
								if ( $display_in_tags == 'all' ) {
									
									$display_in_current = true;
									
									$except_in_tags = get_post_meta( $divibar_id, 'divibars_tag_at_exceptiontags_selected' );
									
									if ( isset ( $except_in_tags[0] ) && $except_in_tags[0] != '' ) {
										
										foreach( $except_in_tags[0] as $in_tag => $the_id ) {
											
											if ( $the_id == $current_tag_id ) {
												
												$display_in_current = false;
												
												break;
											}
										}
									}
								}
							}
							
							if ( is_archive() && $display_on_archive ) {
								
								$display_in_current = true;
							}
							
							if ( ( is_404() || is_search() ) && $display_in_posts === 'all' ) {
								
								$display_in_current = true;
							}
							
							if ( is_author() && $display_on_author ) {
								
								$display_in_current = true;
							}
							
							if ( is_page() && $display_in_posts === 'pages' ) {
								
								$display_in_current = true;
							}
							
							if ( is_single() && $display_in_posts === 'posts' ) {
								
								$display_in_current = true;
							}
							
							if ( is_singular() && ( $display_in_posts === 'posts' || $display_in_posts === 'pages' ) ) {
								
								$display_in_current = true;
							}
							
							if ( $forcerender === true ) {
								
								$display_in_current = true;
							}
							
							if ( $display_in_current ) {
								
								$divibars_in_current[ $divibar_id ] = $divibar_id;
								
								if ( $render ) {
									
									if ( ( is_singular() && is_main_query() )
										|| ( is_archive() 
											&& !is_singular() 
											&& !in_the_loop() )
										|| $forcerender === true ) {
									
										self::$post_id = (int) $divibar_id;
										
										$divibar_content = self::render( self::$post_id );
										
										$the_content = $the_content . $divibar_content;
									}
								}
							}
						}
					}
					
					if ( $render ) {
						
						remove_action( 'wp_body_open', array( 'DiviBars_Controller', 'addDiviBars' ), 1 );
					}
				}
				
				if ( $render ) {
					
					$the_content = $the_content . '</div>';
					
					?>
					<script type="text/javascript">
					var ajaxurl = "<?php echo et_core_intentionally_unescaped( admin_url( 'admin-ajax.php' ), 'fixed_string' ); ?>"
					, diviAjaxUrl = '<?php print et_core_intentionally_unescaped( plugins_url( 'ajax-handler-wp.php' , __FILE__ ), 'fixed_string' ) ; ?>';
					</script>
					<?php
				}
			
			} catch (Exception $e) {
			
				DiviBars::log( $e );
			}
			
			if ( $render ) {
				
				// Add scripts
				DiviBars::add_scripts();
				
				wp_register_script('exit-intent', DIVI_BARS_PLUGIN_URL . 'assets/js/jquery.exitintent.min.js', array('jquery') );
			
				wp_enqueue_script('exit-intent');
			}
			else {
				
				return $divibars_in_current;
			}
			
			if ( !et_pb_is_pagebuilder_used( get_the_ID() ) ) {
				
				$the_content = do_shortcode( $the_content );
				
			} else {
			
				$the_content = apply_filters( 'the_content', $the_content );
			}

			print $the_content;
		}
		
		
		public static function getRender( $post_id = NULL, $avoidRenderTags = 0, $divilifepost = false ) {
			
			try {
				
				if ( !is_numeric( $post_id ) ) {
					
					throw new InvalidArgumentException( 'DiviBars_Controller::getRender > $post_id is not numeric');
				}
				
			} catch (Exception $e) {
			
				DiviBars::log( $e );
			}
			
			$render = array();
			
			$output = '';
			
			if ( $divilifepost === false ) {
				
				global $post;
				
				$post_data = $post;
				
				if ( !isset( $post_data->post_content ) ) {
					
					return false;
				}
			}
			else {
				
				$post_data = get_post( self::$post_id );
			}
			
			$post_content = $post_data->post_content;
			
			$output = $post_content;
			
			$render['post_data'] = $post_data;
			$render['output'] = $output;
			
			return $render;
		}
		
		
		public static function start_module_index_override() {
			ET_Builder_Element::begin_theme_builder_layout( self::$post_id );
			
			add_filter(
				'et_pb_module_shortcode_attributes',
				array( 'DiviBars_Controller', 'do_module_index_override' )
			);
		}
		
		public static function end_module_index_override() {
			ET_Builder_Element::end_theme_builder_layout();
			
			global $et_pb_predefined_module_index;
			
			unset( $et_pb_predefined_module_index );
		}
		
		public static function do_module_index_override( $value = '' ) {
			global $et_pb_predefined_module_index;
			
			self::$module_index ++;
			$et_pb_predefined_module_index = sprintf(
				'dib_%1$s_%2$s',
				self::$post_id,
				self::$module_index
			);
			
			return $value;
		}
		
		
		public static function render() {
			
			ob_start();
			
			$divibar_id = self::$post_id;
			
			/* Scheduling */
			$enable_scheduling = get_post_meta( $divibar_id, 'divibars_enable_scheduling' );
			
			if( !isset( $enable_scheduling[0] ) ) {
				
				$enable_scheduling[0] = 0;
			}
			
			$enable_scheduling = (int) $enable_scheduling[0];
			
			if ( $enable_scheduling ) {
				
				$timezone = DIVI_SERVER_TIMEZONE;
				
				$timezone = new DateTimeZone( $timezone );
				
				$wp_timezone = wp_timezone();
				
				if ( $wp_timezone !== false ) {
					
					$timezone = $wp_timezone;
				}
				
				$date_now = current_datetime();
				
				// Start & End Time
				if ( $enable_scheduling == 1 ) {
					
					$date_start = get_post_meta( $divibar_id, 'divibars_date_start', true );
					$date_end = get_post_meta( $divibar_id, 'divibars_date_end', true );
					
					$date_start = DiviBars::$helper->convertDateToUserTimezone( $date_start );
					$date_start = new DateTimeImmutable( $date_start, $timezone );

					if ( $date_start >= $date_now ) {
						
						return;
					}
					
					if ( $date_end != '' ) {
					
						$date_end = DiviBars::$helper->convertDateToUserTimezone( $date_end );
						$date_end = new DateTimeImmutable( $date_end, $timezone );
						
						if ( $date_end <= $date_now ) {
							
							return;
						}
					}
				}
				
				// Recurring Scheduling
				if ( $enable_scheduling == 2 ) {
					
					$wNum = $date_now->format( 'N' );
					
					$is_today = get_post_meta( $divibar_id, 'divibars_scheduling_daysofweek_' . $wNum );
					
					if ( isset( $is_today[0] ) && $is_today[0] == 1 ) {
						
						$is_today = $is_today[0];
						
						$time_start = get_post_meta( $divibar_id, 'divibars_time_start', true );
						$time_end = get_post_meta( $divibar_id, 'divibars_time_end', true );
						$schedule_start = null;
						$schedule_end = null;
						
						if ( $time_start != '' ) {
							
							$time_start_24 = gmdate( 'H:i', strtotime( $time_start ) );
							$time_start_24 = explode( ':', $time_start_24 );
							$time_start_now = new DateTimeImmutable( 'now', $timezone );
							$schedule_start = $time_start_now->setTime( $time_start_24[0], $time_start_24[1], 0 );
						}
						
						if ( $time_end != '' ) {
							
							$time_end_24 = gmdate( 'H:i', strtotime( $time_end ) );
							$time_end_24 = explode( ':', $time_end_24 );
							$time_end_now = new DateTimeImmutable( 'now', $timezone );
							$schedule_end = $time_end_now->setTime( $time_end_24[0], $time_end_24[1], 0 );
						}
						
						if ( ( $time_start != '' && $time_end != '' && $schedule_start >= $date_now && $schedule_end > $date_now )
							|| ( $time_start != '' && $time_end != '' && $schedule_start <= $date_now && $schedule_end < $date_now )
							|| ( $time_start != '' && $time_end == '' && $schedule_start <= $date_now )
							|| ( $time_start == '' && $time_end != '' && $schedule_end < $date_now )
							) {
							
							return;
						}
						
					} else {
				
						return;
					}
				}
			}
			
			$divilifepost = true;
			
			$render = self::getRender( $divibar_id, 0, $divilifepost );
			
			$post_data = $render['post_data'];
			
			$output = $render['output'];
			
			$divibar_effect = '';
			
			$bgcolor = get_post_meta( $post_data->ID, 'post_divibars_bg_color', true );
			$fontcolor = get_post_meta( $post_data->ID, 'post_divibars_font_color', true );
			
			$hideclosebtn = get_post_meta( $post_data->ID, 'post_do_hideclosebtn' );
			if ( isset( $hideclosebtn[0] ) ) {
				
				$hideclosebtn = $hideclosebtn[0];
				
			} else {
				
				$hideclosebtn = 0;
			}
			
			$placement = get_post_meta( $post_data->ID, 'dib_post_placement', true );
			if( !isset( $placement ) ) {
				
				$placement = 'top';
			}
			
			$pushpage = get_post_meta( $post_data->ID, 'post_pushpage' );
			if ( isset( $pushpage[0] ) ) {
				
				$pushpage = $pushpage[0];
				
			} else {
				
				$pushpage = 1;
			}
			
			$screenfixed = 0;
			
			if ( $placement != 'bottom' ) {
				
				$screenfixed = get_post_meta( $post_data->ID, 'post_screenfixed' );
				if ( isset( $screenfixed[0] ) ) {
					
					$screenfixed = $screenfixed[0];
					
				} else {
					
					$screenfixed = 1;
				}
			}
			
			$customizeclosebtn = get_post_meta( $post_data->ID, 'post_do_customizeclosebtn' );
			if( !isset( $customizeclosebtn[0] ) ) {
				
				$customizeclosebtn[0] = '0';
			}
			
			$close_cookie = get_post_meta( $post_data->ID, 'post_closebtn_cookie', true );
			if( !isset( $close_cookie ) ) {
				
				$close_cookie = 1;
			}
			
			$is_mobile = DiviBars::$isMobileDevice;
			$is_tablet = DiviBars::$isTabletDevice;
			
			if ( !$is_mobile ) {
				
				$is_mobile = 0;
			}
			
			if ( !$is_tablet ) {
				
				$is_tablet = 0;
			}
			
			$body = $output;
			
			require( DIVI_BARS_PLUGIN_DIR . '/templates/divibar.php');
			
			$divibar_content = ob_get_contents();
			ob_end_clean();
			
			return $divibar_content;
		}
		
	} // end DiviBars_Controller