<?php

	class DiviBars_Admin_Controller {
		
		protected static $_show_errors = FALSE;
		
		public static function get_wp_posts() {
			
			check_ajax_referer( 'divilife_divibars', 'nonce' );
			
			if ( isset( $_POST['q'] ) ) {
			
				$q = sanitize_text_field( wp_unslash( $_POST['q'] ) );
			
			} else {
				
				return;
			}
			
			
			if ( isset( $_POST['page'] ) ) {
				
				$page = (int) $_POST['page'];
				
			} else {
				
				$page = 1;
			}
			
			
			if ( isset( $_POST['json'] ) ) {
				
				$json = (int) $_POST['json'];
				
			} else {
				
				$json = 0;
			}
			
			$data = null;
			
			if ( ! function_exists( 'et_get_registered_post_type_options' ) ) {
				
				$data = wp_json_encode(
				
					array(
						'total_count' => 1,
						'items' => array( 0 => (object) array( 'id' => 0, 'post_title' => 'This functionality requires Divi.' ) )
					)
				);
				
				// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				die( $data );
			}
			
			$post_types = et_get_registered_post_type_options();
			
			$excluded_post_types = array( 'attachment', 'revision', 'nav_menu_item', 'custom_css', 'et_pb_layout', 'divi_bars', 'divi_overlay', 'divi_mega_pro', 'customize_changeset' );
			
			$post_types = array_diff( array_keys( $post_types ), $excluded_post_types );
			
			$args = array(
				'divibars_by_title_like' => $q,
				'post_type' => $post_types,
				'cache_results'  => false,
				'posts_per_page' => 7,
				'paged' => $page,
				'orderby' => 'id',
				'order' => 'DESC'
			);
			
			add_filter( 'posts_where', array( 'DiviBars_Admin_Controller', 'divibars_title_filter'), 10, 2 );
			$query = new WP_Query( $args );
			remove_filter( 'posts_where', array( 'DiviBars_Admin_Controller', 'divibars_title_filter'), 10, 2 );
			
			$total_count = (int) $query->found_posts;
			
			$posts = array();
			
			if ( $query->have_posts() ) {
				
				while ( $query->have_posts() ) {
					
					$query->the_post();
					
					$post_filtered = array();
					
					$post_filtered[ 'id' ] = get_the_ID();
					$post_filtered[ 'post_title' ] = get_the_title();
					
					$posts[] = $post_filtered;
					
				}
			}
			wp_reset_postdata();
			
			if ( $json ) {
				
				header( 'Content-type: application/json' );
				$data = wp_json_encode(
				
					array(
						'total_count' => $total_count,
						'items' => $posts
					)
				);
				
				// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				die( $data );
			}
			
			return $posts;
		}
		
		
		public static function divibars_title_filter( $where, $wp_query )
		{
			global $wpdb;
			
			if ( $search_term = $wp_query->get( 'divibars_by_title_like' ) ) {
				$where .= ' AND ' . $wpdb->posts . '.post_title LIKE \'%' . $wpdb->esc_like( $search_term ) . '%\'';
			}
			
			return $where;
		}


		public static function get_wp_categories() {
			
			check_ajax_referer( 'divilife_divibars', 'nonce' );
			
			if ( isset( $_POST['q'] ) ) {
			
				$q = sanitize_text_field( wp_unslash( $_POST['q'] ) );
			
			} else {
				
				return;
			}
			
			
			if ( isset( $_POST['page'] ) ) {
				
				$page = (int) $_POST['page'];
				
			} else {
				
				$page = 1;
			}
			
			
			if ( isset( $_POST['json'] ) ) {
				
				$json = (int) $_POST['json'];
				
			} else {
				
				$json = 0;
			}
			
			$data = null;
			
			$limit = 7;
			$offset = ( $page - 1 ) * $limit;
			
			$args = array(
				'taxonomy'               => array( 'category', 'project_category', 'product_cat' ),
				'name__like'             => $q,
				'number'                 => $limit,
				'offset'                 => $offset,
				'fields'                 => 'id=>name',
				'hide_empty'             => false,
				'get'                    => 'all',
				'orderby'				 => 'name',
				'order'					 => 'ASC'
			);
			
			$term_query = new WP_Term_Query( $args );
			
			// Get all categories found
			$args['number'] = '';
			$totalterm_query = new WP_Term_Query( $args );
			
			$json_posts = array();
			if ( ! empty( $term_query ) && ! is_wp_error( $term_query ) ) {
				
				$categories = $term_query->get_terms();
				
				$total_count = (int) count( $totalterm_query->get_terms() );
				
				$pop_categories = array();
				foreach( $categories as $term_id => $term_name ) {
					$pop_categories[ 'id' ] = $term_id;
					$pop_categories[ 'name' ] = $term_name;
					$json_posts[] = $pop_categories;
				}
				
			} else {
				
				
			}
			
			if ( $json ) {
				
				header( 'Content-type: application/json' );
				$data = wp_json_encode(
				
					array(
						'total_count' => $total_count,
						'items' => $json_posts
					)
				);
				
				// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				die( $data );
			}
		}
		
		
		public static function get_wp_tags() {
			
			check_ajax_referer( 'divilife_divibars', 'nonce' );
			
			if ( isset( $_POST['q'] ) ) {
			
				$q = sanitize_text_field( wp_unslash( $_POST['q'] ) );
			
			} else {
				
				return;
			}
			
			
			if ( isset( $_POST['page'] ) ) {
				
				$page = (int) $_POST['page'];
				
			} else {
				
				$page = 1;
			}
			
			
			if ( isset( $_POST['json'] ) ) {
				
				$json = (int) $_POST['json'];
				
			} else {
				
				$json = 0;
			}
			
			$data = null;
			
			$limit = 7;
			$offset = ( $page - 1 ) * $limit;
			
			$args = array(
				'taxonomy'               => array( 'post_tag' ),
				'name__like'             => $q,
				'number'                 => $limit,
				'offset'                 => $offset,
				'fields'                 => 'id=>name',
				'hide_empty'             => false,
				'get'                    => 'all',
				'orderby'				 => 'name',
				'order'					 => 'ASC'
			);
			
			$term_query = new WP_Term_Query( $args );
			
			// Get all tags found
			$args['number'] = '';
			$totalterm_query = new WP_Term_Query( $args );
			
			$json_posts = array();
			if ( ! empty( $term_query ) && ! is_wp_error( $term_query ) ) {
				
				$tags = $term_query->get_terms();
				
				$total_count = (int) count( $totalterm_query->get_terms() );
				
				$pop_tags = array();
				foreach( $tags as $term_id => $term_name ) {
					$pop_tags[ 'id' ] = $term_id;
					$pop_tags[ 'name' ] = $term_name;
					$json_posts[] = $pop_tags;
				}
				
			} else {
				
				
			}
			
			if ( $json ) {
				
				header( 'Content-type: application/json' );
				$data = wp_json_encode(
				
					array(
						'total_count' => $total_count,
						'items' => $json_posts
					)
				);
				
				// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				die( $data );
			}
		}
		
		
		private static function keysToLower( &$obj )
		{
			$type = (int) is_object($obj) - (int) is_array($obj);
			if ($type === 0) return $obj;
			foreach ($obj as $key => &$val)
			{
				$element = self::keysToLower($val);
				switch ($type)
				{
				case 1:
					if (!is_int($key) && $key !== ($keyLowercase = strtolower($key)))
					{
						unset($obj->{$key});
						$key = $keyLowercase;
					}
					$obj->{$key} = $element;
					break;
				case -1:
					if (!is_int($key) && $key !== ($keyLowercase = strtolower($key)))
					{
						unset($obj[$key]);
						$key = $keyLowercase;
					}
					$obj[$key] = $element;
					break;
				}
			}
			return $obj;
		}
		
		
		public static function add_meta_boxes() {
			
			if ( isset( $_GET['page'] ) && $_GET['page'] === 'divibars-settings' ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended 
				
				return;
			}
			
			$screen = get_current_screen();
			
			if ( $screen->post_type == 'divi_bars' ) {
				
				$status = get_option( 'divilife_edd_divibars_license_status' );
				$check_license = divilife_edd_divibars_check_license( TRUE );
				
				if ( ( isset( $check_license->license ) && $check_license->license !== 'valid' && 'add' === $screen->action ) 
					|| ( isset( $check_license->license ) && isset( $_GET['action'] ) && $check_license->license !== 'valid' && 'edit' === $_GET['action'] ) // phpcs:ignore WordPress.Security.NonceVerification.Recommended
					|| ( $status === false && 'add' === $screen->action ) 
					|| ( $status === false && isset( $_GET['action'] ) && 'edit' === $_GET['action'] ) // phpcs:ignore WordPress.Security.NonceVerification.Recommended
					) {
					
					$message = '';
					$base_url = admin_url( 'edit.php?post_type=divi_bars&page=divibars-settings' );
					$redirect = add_query_arg( array( 'message' => rawurlencode( $message ), 'divilife' => 'divibars' ), $base_url );
					
					wp_safe_redirect( $redirect );
					exit();
				}
				
				if ( 'add' !== $screen->action ) {
					
					add_meta_box( 
						'divibars_manualtriggers', 
						esc_html__( 'Manual Triggers', 'DiviBars' ), 
						array( 'DiviBars_Admin_Controller', 'manualtriggers_callback' ), 
						'divi_bars', 
						'side',
						'high'
					);
				}
				
				add_meta_box( 
					'divibars_displaylocations_meta_box1', 
					esc_html__( 'Display Locations', 'DiviBars' ), 
					array( 'DiviBars_Admin_Controller', 'divibars_displaylocations_callback' ),
					'divi_bars', 
					'side'
				);
				
				add_meta_box( 
					'divibars_moresettings_meta_box2', 
					esc_html__( 'Additional Settings', 'DiviBars' ), 
					array( 'DiviBars_Admin_Controller', 'divibars_moresettings_callback' ),
					'divi_bars', 
					'side'
				);
				
				add_meta_box( 
					'divibars_closecustoms_meta_box3', 
					esc_html__( 'Close Button Customizations', 'DiviBars' ), 
					array( 'DiviBars_Admin_Controller', 'divibars_closecustoms_callback' ), 
					'divi_bars', 
					'side'
				);
				
				add_meta_box( 
					'divibars_automatictriggers4', 
					esc_html__( 'Automatic Triggers', 'DiviBars' ), 
					array( 'DiviBars_Admin_Controller', 'divibars_automatictriggers_callback' ), 
					'divi_bars', 
					'side'
				);
			}
		}
		
		
		public static function removefields_from_customfieldsmetabox( $protected, $meta_key ) {
			
			if ( function_exists( 'get_current_screen' ) ) {
				
				$screen = get_current_screen();
				
				$remove = $protected;
				
				if ( $screen !== null ) {
				
					if ( $meta_key == 'at_pages'
						|| $meta_key == 'at_pages_selected'
						|| $meta_key == 'at_pagesexception_selected'
						|| $meta_key == 'divibar_effect'
						|| $meta_key == 'dib_css_selector' 
						|| $meta_key == 'post_pushpage'
						|| $meta_key == 'post_screenfixed'
						|| $meta_key == 'dib_enableurltrigger' 
						|| $meta_key == 'dib_post_placement' 
						|| $meta_key == 'post_closebtn_cookie' 
						|| $meta_key == 'post_closebtn_text_color' 
						|| $meta_key == 'post_closebtn_bg_color' 
						|| $meta_key == 'post_closebtn_fontsize' 
						|| $meta_key == 'post_closebtn_borderradius' 
						|| $meta_key == 'post_closebtn_padding' 
						|| $meta_key == 'post_do_hideclosebtn'
						|| $meta_key == 'post_do_customizeclosebtn'
						|| $meta_key == 'divibars_automatictrigger_disablemobile'
						|| $meta_key == 'divibars_automatictrigger_disabletablet'
						|| $meta_key == 'divibars_automatictrigger_disabledesktop'
						|| $meta_key == 'divibars_automatictrigger_onceperload'
						|| $meta_key == 'divibars_enable_scheduling'
						|| $meta_key == 'divibars_date_start'
						|| $meta_key == 'divibars_date_end'
						|| $meta_key == 'divibars_time_start'
						|| $meta_key == 'divibars_time_end'
						|| $meta_key == 'divibars_automatictrigger'
						|| $meta_key == 'divibars_scheduling_daysofweek_1'
						|| $meta_key == 'divibars_scheduling_daysofweek_2'
						|| $meta_key == 'divibars_scheduling_daysofweek_3'
						|| $meta_key == 'divibars_scheduling_daysofweek_4'
						|| $meta_key == 'divibars_scheduling_daysofweek_5'
						|| $meta_key == 'divibars_scheduling_daysofweek_6'
						|| $meta_key == 'divibars_scheduling_daysofweek_7'
						|| $meta_key == 'divibars_automatictrigger_timed_value'
						|| $meta_key == 'divibars_automatictrigger_scroll_from_value'
						|| $meta_key == 'divibars_automatictrigger_scroll_to_value'
						) {
							
						$remove = true;
					}
				}
				
				return $remove;
			}
		}
		
		
		public static function manualtriggers_callback( $post ) {
			?>
			<div class="divilife_meta_box">
				<p>
					<label class="label-color-field"><p>CSS ID:</label>
					divibars_unique_id_<?php print et_core_esc_previously( $post->ID ) ?></p>
				</p>
				<div class="clear"></div> 
			</div> 
			<div class="divilife_meta_box">
				<p>
					<label class="label-color-field"><p>Menu ID:</label>
					unique_divibars_menu_id_<?php print et_core_esc_previously( $post->ID ) ?></p>
				</p>
				<div class="clear"></div> 
			</div>
			<?php
		}
		
		
		public static function divibars_displaylocations_callback( $post ) {
		
			wp_nonce_field( 'divibars_displaylocations', 'divibars_displaylocations_nonce' );
			
			$at_pages = get_post_meta( $post->ID, 'at_pages', true );
			$selectedpages = get_post_meta( $post->ID, 'at_pages_selected' );
			$selectedexceptpages = get_post_meta( $post->ID, 'at_pagesexception_selected' );
			
			$at_categories = get_post_meta( $post->ID, 'divibars_category_at_categories', true );
			$selectedcategories = get_post_meta( $post->ID, 'divibars_category_at_categories_selected' );
			$selectedexceptcategories = get_post_meta( $post->ID, 'divibars_category_at_exceptioncategories_selected' );
			
			$at_tags = get_post_meta( $post->ID, 'divibars_tag_at_tags', true );
			$selectedtags = get_post_meta( $post->ID, 'divibars_tag_at_tags_selected' );
			$selectedexcepttags = get_post_meta( $post->ID, 'divibars_tag_at_exceptiontags_selected' );
			
			if( $at_pages == '' ) {
				
				$at_pages = 'all';
			}
			
			if( $at_categories == '' ) {
				
				$at_categories = 'all';
			}
			
			if( $at_tags == '' ) {
				
				$at_tags = 'all';
			}
			
			$archive = get_post_meta( $post->ID, 'divibars_displaylocations_archive' );
			
			if( !isset( $archive[0] ) ) {
				
				$archive[0] = '1';
			}
			
			$author = get_post_meta( $post->ID, 'divibars_displaylocations_author' );
			
			if( !isset( $author[0] ) ) {
				
				$author[0] = '1';
			}
			
			$forcerender = get_post_meta( $post->ID, 'divibars_displaylocations_forcerender' );
			
			if( !isset( $forcerender[0] ) ) {
				
				$forcerender[0] = '0';
			}
			
			?>
			<script type="text/javascript">
			var divilife_divibars = "<?php print wp_create_nonce( 'divilife_divibars' ) // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>";
			</script>
			<div class="divilife_meta_box">
				<div class="at_pages">
					<select name="post_at_pages" class="at_pages chosen divibars-filter-by-pages" data-dropdownshowhideblock="1">
						<option value="all"<?php if ( $at_pages == 'all' ) { ?> selected="selected"<?php } ?> data-showhideblock=".divibars-list-exceptionpages-container"><?php esc_html_e( 'All posts and pages', 'DiviBars' ); ?></option>
						<option value="posts"<?php if ( $at_pages == 'posts' ) { ?> selected="selected"<?php } ?> data-showhideblock=""><?php esc_html_e( 'All posts', 'DiviBars' ); ?></option>
						<option value="pages"<?php if ( $at_pages == 'pages' ) { ?> selected="selected"<?php } ?> data-showhideblock=""><?php esc_html_e( 'All pages', 'DiviBars' ); ?></option>
						<option value="specific"<?php if ( $at_pages == 'specific' ) { ?> selected="selected"<?php } ?> data-showhideblock=".divibars-list-pages-container"><?php esc_html_e( 'Only specific pages', 'DiviBars' ); ?></option>
					</select>
					<div class="divibars-list-pages-container<?php if ( $at_pages == 'specific' ) { ?> divibars-show<?php } ?>">
						<select name="post_at_pages_selected[]" class="divibars-list-pages" data-placeholder="<?php esc_html_e( 'Choose posts or pages', 'DiviBars' ); ?>..." multiple tabindex="3">
						<?php
							if ( isset( $selectedpages[0] ) && is_array( $selectedpages[0] )  ) {
								
								foreach( $selectedpages[0] as $selectedidx => $selectedvalue ) {
									
									$post_title = get_the_title( $selectedvalue );
									
									print '<option value="' . esc_attr( $selectedvalue ) . '" selected="selected">' . esc_attr( $post_title ) . '</option>';
								}
							}
						?>
						</select>
					</div>
					<div class="divibars-list-exceptionpages-container<?php if ( $at_pages == 'all' ) { ?> divibars-show<?php } ?>">
						<h4 class="db-exceptedpages"><?php esc_html_e( 'Add Exceptions', 'DiviBars' ); ?>:</h4>
						<select name="post_at_exceptionpages_selected[]" class="divibars-list-pages" data-placeholder="<?php esc_html_e( 'Choose posts or pages', 'DiviBars' ); ?>..." multiple tabindex="3">
						<?php
							if ( isset( $selectedexceptpages[0] ) && is_array( $selectedexceptpages[0] )  ) {
								
								foreach( $selectedexceptpages[0] as $selectedidx => $selectedvalue ) {
									
									$post_title = get_the_title( $selectedvalue );
									
									print '<option value="' . esc_attr( $selectedvalue ) . '" selected="selected">' . esc_attr( $post_title ) . '</option>';
								}
							}
						?>
						</select>
					</div>
				</div>
				<div class="at_categories">
					<select name="divibars_category_at_categories" class="at_categories chosen do-filter-by-categories" data-dropdownshowhideblock="1">
						<option value="all"<?php if ( $at_categories == 'all' ) { ?> selected="selected"<?php } ?> data-showhideblock=".divibars-list-exceptioncategories-container"><?php esc_html_e( 'All categories', 'DiviBars' ); ?></option>
						<option value="specific"<?php if ( $at_categories == 'specific' ) { ?> selected="selected"<?php } ?> data-showhideblock=".divibars-list-categories-container"><?php esc_html_e( 'Only specific categories', 'DiviBars' ); ?></option>
					</select>
					<div class="divibars-list-categories-container<?php if ( $at_categories == 'specific' ) { ?> divibars-show<?php } ?>">
						<select name="divibars_category_at_categories_selected[]" class="divibars-list-categories" data-placeholder="<?php esc_html_e( 'Choose categories', 'DiviBars' ); ?>..." multiple tabindex="3">
						<?php
							if ( isset( $selectedcategories[0] ) && is_array( $selectedcategories[0] ) ) {
								
								foreach( $selectedcategories[0] as $selectedidx => $selectedvalue ) {
									
									$cat_name = get_cat_name( $selectedvalue );
									
									print '<option value="' . esc_attr( $selectedvalue ) . '" selected="selected">' . esc_attr( $cat_name ) . '</option>';
								}
							}
						?>
						</select>
					</div>
					<div class="divibars-list-exceptioncategories-container<?php if ( $at_categories == 'all' ) { ?> divibars-show<?php } ?>">
						<h4 class="divibars-exceptedcategories"><?php esc_html_e( 'Add Exceptions', 'DiviBars' ); ?>:</h4>
						<select name="divibars_category_at_exceptioncategories_selected[]" class="divibars-list-categories" data-placeholder="<?php esc_html_e( 'Choose categories', 'DiviBars' ); ?>..." multiple tabindex="3">
						<?php
							if ( isset( $selectedexceptcategories[0] ) && is_array( $selectedexceptcategories[0] ) ) {
								
								foreach( $selectedexceptcategories[0] as $selectedidx => $selectedvalue ) {
									
									$cat_name = get_cat_name( $selectedvalue );
									
									print '<option value="' . esc_attr( $selectedvalue ) . '" selected="selected">' . esc_attr( $cat_name ) . '</option>';
								}
							}
						?>
						</select>
					</div>
				</div>
				<div class="at_tags">
					<select name="divibars_tag_at_tags" class="at_tags chosen do-filter-by-tags" data-dropdownshowhideblock="1">
						<option value="all"<?php if ( $at_tags == 'all' ) { ?> selected="selected"<?php } ?> data-showhideblock=".divibars-list-exceptiontags-container"><?php esc_html_e( 'All tags', 'DiviBars' ); ?></option>
						<option value="specific"<?php if ( $at_tags == 'specific' ) { ?> selected="selected"<?php } ?> data-showhideblock=".divibars-list-tags-container"><?php esc_html_e( 'Only specific tags', 'DiviBars' ); ?></option>
					</select>
					<div class="divibars-list-tags-container<?php if ( $at_tags == 'specific' ) { ?> divibars-show<?php } ?>">
						<select name="divibars_tag_at_tags_selected[]" class="divibars-list-tags" data-placeholder="<?php esc_html_e( 'Choose tags', 'DiviBars' ); ?>..." multiple tabindex="3">
						<?php
							if ( isset( $selectedtags[0] ) && is_array( $selectedtags[0] ) ) {
								
								foreach( $selectedtags[0] as $selectedidx => $selectedvalue ) {
									
									$term_name = get_term( $selectedvalue );
									
									print '<option value="' . esc_attr( $selectedvalue ) . '" selected="selected">' . esc_attr( $term_name->name ) . '</option>';
								}
							}
						?>
						</select>
					</div>
					<div class="divibars-list-exceptiontags-container<?php if ( $at_tags == 'all' ) { ?> divibars-show<?php } ?>">
						<h4 class="divibars-exceptedtags"><?php esc_html_e( 'Add Exceptions', 'DiviBars' ); ?>:</h4>
						<select name="divibars_tag_at_exceptiontags_selected[]" class="divibars-list-tags" data-placeholder="<?php esc_html_e( 'Choose tags', 'DiviBars' ); ?>..." multiple tabindex="3">
						<?php
							if ( isset( $selectedexcepttags[0] ) && is_array( $selectedexcepttags[0] ) ) {
								
								foreach( $selectedexcepttags[0] as $selectedidx => $selectedvalue ) {
									
									$term_name = get_term( $selectedvalue );
									
									print '<option value="' . esc_attr( $selectedvalue ) . '" selected="selected">' . esc_attr( $term_name->name ) . '</option>';
								}
							}
						?>
						</select>
					</div>
				</div>
				<div class="divilife_meta_box">
					<p>
						<input name="divibars_displaylocations_archive" type="checkbox" id="divibars_displaylocations_archive" value="1" <?php checked( $archive[0], 1 ); ?> /> <?php esc_html_e( 'Archive', 'DiviBars' ); ?>
					</p>
				</div>
				<div class="divilife_meta_box">
					<p>
						<input name="divibars_displaylocations_author" type="checkbox" id="divibars_displaylocations_author" value="1" <?php checked( $author[0], 1 ); ?> /> <?php esc_html_e( 'Author', 'DiviBars' ); ?>
					</p>
				</div>
				<div class="divilife_meta_box">
					<p>
						<input name="divibars_displaylocations_forcerender" type="checkbox" id="divibars_displaylocations_forcerender" value="1" <?php checked( $forcerender[0], 1 ); ?> /> <?php esc_html_e( 'Force render', 'DiviBars' ); ?>
					</p>
				</div>
				<div class="clear"></div> 
			</div>
			<?php
		}
		
		
		public static function divibars_effects_callback( $post ) {
			
			$post_id = get_the_ID();
			$divibar_effect = get_post_meta( $post_id, 'divibar_effect', true );
			$divibar_effects = array(
				'divibars-hugeinc'   => esc_html__( 'Fade & Slide', 'DiviBars' ),
				'divibars-corner'    => esc_html__( 'Corner', 'DiviBars' ),
				'divibars-slidedown' => esc_html__( 'Slide down', 'DiviBars' ),
				'divibars-scale' => esc_html__( 'Scale', 'DiviBars' ),
				'divibars-door' => esc_html__( 'Door', 'DiviBars' ),
				'divibars-contentpush' => esc_html__( 'Content Push', 'DiviBars' ),
				'divibars-contentscale' => esc_html__( 'Content Scale', 'DiviBars' ),
				'divibars-cornershape' => esc_html__( 'Corner Shape', 'DiviBars' ),
				'divibars-boxes' => esc_html__( 'Little Boxes', 'DiviBars' ),
				'divibars-simplegenie' => esc_html__( 'Simple Genie', 'DiviBars' ),
				'divibars-genie' => esc_html__( 'Genie', 'DiviBars' ),
			);
			?>
			<p class="et_pb_page_settings et_pb_single_title">
				<label for="divibar_effect" class="divibar-label-effect"><?php esc_html_e( 'Select DiviBars Animation', 'DiviBars' ); ?>: </label>
				<select id="divibar_effect" name="divibar_effect" class="chosen">
				<?php
				foreach ( $divibar_effects as $divibar_value => $divibar_name ) {
					printf( '<option value="%2$s"%3$s>%1$s</option>',
						esc_html( $divibar_name ),
						esc_attr( $divibar_value ),
						selected( $divibar_value, $divibar_effect, false )
					);
				} ?>
				</select>
			</p>
			
		<?php }
		
		
		public static function divibars_moresettings_callback( $post ) {
		
			wp_nonce_field( 'divibars_moresettings', 'divibars_moresettings_nonce' );
			
			$css_selector = get_post_meta( $post->ID, 'dib_css_selector', true );
			
			$pushpage = get_post_meta( $post->ID, 'post_pushpage' );
			if( !isset( $pushpage[0] ) ) {
				
				$pushpage[0] = '1';
			}
			
			$screenfixed = get_post_meta( $post->ID, 'post_screenfixed' );
			if( !isset( $screenfixed[0] ) ) {
				
				$screenfixed[0] = '0';
			}
			
			$enableurltrigger = get_post_meta( $post->ID, 'dib_enableurltrigger' );
			if( !isset( $enableurltrigger[0] ) ) {
				
				$enableurltrigger[0] = '0';
			}
			
			$divibar_placement = get_post_meta( $post->ID, 'dib_post_placement', true );
			
			$divibars_showguests = get_post_meta( $post->ID, 'divibars_showguests' );
			
			$divibars_showusers = get_post_meta( $post->ID, 'divibars_showusers' );
			
			if( !isset( $divibars_showguests[0] ) ) {
				
				$divibars_showguests[0] = '0';
			}
			
			if( !isset( $divibars_showusers[0] ) ) {
				
				$divibars_showusers[0] = '0';
			}
			
			?>
			<div class="divilife_meta_box">
				<p>
					<label><?php esc_html_e( 'CSS Selector Trigger', 'DiviBars' ); ?>:</label>
					<input class="css_selector" type="text" name="dib_css_selector" value="<?php print et_core_esc_previously( $css_selector ); ?>"/>
				</p>
				<div class="clear"></div> 
			</div>
			<?php
			
			if( !isset( $divibar_placement ) ) {
				
				$divibar_placement = 'top';
			}
			
			$divibar_ats = array(
				'top'   => esc_html__( 'Top', 'DiviBars' ),
				'bottom'    => esc_html__( 'Bottom', 'DiviBars' )
			);
			?>
			<div class="divilife_meta_box">
				<p class="divibar_placement et_pb_single_title">
					<label for="dib_post_placement"><?php esc_html_e( 'Position', 'DiviBars' ); ?>:</label>
					<select id="dib_post_placement" name="dib_post_placement" class="post_divibar_placement chosen">
					<?php
					foreach ( $divibar_ats as $at_value => $at_name ) {
						printf( '<option value="%2$s"%3$s>%1$s</option>',
							esc_html( $at_name ),
							esc_attr( $at_value ),
							selected( $at_value, $divibar_placement, false )
						);
					} ?>
					</select>
				</p>
			</div>
			
			<div class="divilife_meta_box">
				<p>
					<input name="post_pushpage" type="checkbox" id="post_pushpage" value="1" <?php checked( $pushpage[0], 1 ); ?> /> <?php esc_html_e( 'Push Page Up/Down', 'DiviBars' ); ?> 
				</p>
				<div class="clear"></div> 
			</div>
			
			<div class="divilife_meta_box moresettings_screenfixed<?php if ( $divibar_placement == 'bottom' ) { ?> divibars-hide<?php } ?>">
				<p>
					<input name="post_screenfixed" type="checkbox" id="post_screenfixed" value="1" <?php checked( $screenfixed[0], 1 ); ?> /> <?php esc_html_e( 'Do not Fix to Top', 'DiviBars' ); ?>
				</p>
				<div class="clear"></div> 
			</div>
			
			<div class="divilife_meta_box">
				<p>
					<label for="dib_enableurltrigger"></label>
					<input name="dib_enableurltrigger" type="checkbox" class="dib_enableurltrigger" data-showhideblock=".dib_enableurltrigger_filters" value="1" <?php checked( $enableurltrigger[0], 1 ); ?> /> <?php esc_html_e( 'Enable URL Trigger', 'DiviBars' ); ?>
				</p>
				<div class="clear"></div> 
			</div>
			
			<div class="divilife_meta_box">
				<p>
					<input name="divibars_showguests" type="checkbox" class="divibars_showguests" value="1" <?php checked( $divibars_showguests[0], 1 ); ?> /> <?php esc_html_e( 'Show for Guests only', 'DiviBars' ); ?>
				</p>
			</div>
			
			<div class="divilife_meta_box">
				<p>
					<input name="divibars_showusers" type="checkbox" class="divibars_showusers" value="1" <?php checked( $divibars_showusers[0], 1 ); ?> /> <?php esc_html_e( 'Show for Registered Users only', 'DiviBars' ); ?>
				</p>
			</div>
			<?php
		}
		
		
		public static function divibars_closecustoms_callback( $post ) {
			
			wp_nonce_field( 'divibars_closecustoms', 'divibars_closecustoms_nonce' );
			
			$close_cookie = get_post_meta( $post->ID, 'post_closebtn_cookie', true );
			$textcolor = get_post_meta( $post->ID, 'post_closebtn_text_color', true );
			$bgcolor = get_post_meta( $post->ID, 'post_closebtn_bg_color', true );
			$fontsize = get_post_meta( $post->ID, 'post_closebtn_fontsize', true );
			$borderradius = get_post_meta( $post->ID, 'post_closebtn_borderradius', true );
			$padding = get_post_meta( $post->ID, 'post_closebtn_padding', true );
			
			if( $close_cookie == '' ) {
				
				$close_cookie = 0;
			}
			
			if( $fontsize == '' ) {
				
				$fontsize = 25;
			}
			
			$hideclosebtn = get_post_meta( $post->ID, 'post_do_hideclosebtn' );
			if( !isset( $hideclosebtn[0] ) ) {
				
				$hideclosebtn[0] = '0';
			}
			
			$customizeclosebtn = get_post_meta( $post->ID, 'post_do_customizeclosebtn' );
			if( !isset( $customizeclosebtn[0] ) ) {
				
				$customizeclosebtn[0] = '0';
			}
			
			?>
			<div class="divilife_meta_box">
				<p>
					<label><?php esc_html_e( 'Close Button Cookie', 'DiviBars' ); ?>:</label>
					<input class="post_closebtn_cookie" type="text" name="post_closebtn_cookie" value="<?php echo et_core_esc_previously( $close_cookie ); ?>" readonly="readonly"> <?php esc_html_e( 'days', 'DiviBars' ); ?>
				</p>
				<div id="slider-closebtn-cookie" class="slider-bar"></div>
			</div>
			
			<div class="divilife_meta_box">
				<p>
					<input name="post_do_hideclosebtn" type="checkbox" id="post_do_hideclosebtn" value="1" <?php checked( $hideclosebtn[0], 1 ); ?> /> <?php esc_html_e( 'Hide Main Close Button', 'DiviBars' ); ?>
				</p>
				<div class="clear"></div> 
			</div>
			
			<div class="divilife_meta_box">
				<p>
					<input name="post_do_customizeclosebtn" type="checkbox" id="post_do_customizeclosebtn" value="1" data-showhideblock=".enable_customizations" <?php checked( $customizeclosebtn[0], 1 ); ?> /> <?php esc_html_e( 'Customize Close Button', 'DiviBars' ); ?>
				</p>
				<div class="enable_customizations<?php if ( $customizeclosebtn[0] == 1 ) { ?> divibars-show<?php } ?>">
					<div class="divilife_meta_box">
						<p>
							<label class="label-color-field"><?php esc_html_e( 'Text color', 'DiviBars' ); ?>:</label>
							<input class="closebtn-text-color" type="text" name="post_closebtn_text_color" value="<?php echo esc_attr( $textcolor ); ?>"/>
						</p>
						<div class="clear"></div> 
					</div> 
					<div class="divilife_meta_box">
						<p>
							<label class="label-color-field"><?php esc_html_e( 'Background color', 'DiviBars' ); ?>:</label>
							<input class="closebtn-bg-color" type="text" name="post_closebtn_bg_color" value="<?php echo esc_attr( $bgcolor ); ?>"/>
						</p>
						<div class="clear"></div> 
					</div>
					<div class="divilife_meta_box">
						<p>
							<label><?php esc_html_e( 'Font size', 'DiviBars' ); ?>:</label>
							<input class="post_closebtn_fontsize" type="text" name="post_closebtn_fontsize" value="<?php echo esc_attr( $fontsize ); ?>" readonly="readonly" > px
						</p>
						<div id="slider-closebtn-fontsize" class="slider-bar"></div>
					</div>
					<div class="divilife_meta_box">
						<p>
							<label><?php esc_html_e( 'Border radius', 'DiviBars' ); ?>:</label>
							<input class="post_closebtn_borderradius" type="text" name="post_closebtn_borderradius" value="<?php echo esc_attr( $borderradius ); ?>" readonly="readonly" > %
						</p>
						<div id="slider-closebtn-borderradius" class="slider-bar"></div>
					</div>
					<div class="divilife_meta_box">
						<p>
							<label><?php esc_html_e( 'Padding', 'DiviBars' ); ?>:</label>
							<input class="post_closebtn_padding" type="text" name="post_closebtn_padding" value="<?php echo esc_attr( $padding ); ?>" readonly="readonly" > px
						</p>
						<div id="slider-closebtn-padding" class="slider-bar"></div>
					</div>
					<div class="divilife_meta_box">
						<p>
							<label><?php esc_html_e( 'Preview', 'DiviBars' ); ?>:</label>
						</p>
						<button type="button" class="divibars-customclose-btn"><span>&times;</span></button>
					</div>
				</div>
				<div class="clear"></div> 
			</div>
			<?php
		}
		
		
		public static function divibars_automatictriggers_callback( $post ) {
			
			$post_id = get_the_ID();
			
			$disablemobile = get_post_meta( $post_id, 'divibars_automatictrigger_disablemobile' );
			$disabletablet = get_post_meta( $post_id, 'divibars_automatictrigger_disabletablet' );
			$disabledesktop = get_post_meta( $post_id, 'divibars_automatictrigger_disabledesktop' );
			
			$onceperload = get_post_meta( $post_id, 'divibars_automatictrigger_onceperload' );
			
			$enable_scheduling = get_post_meta( $post_id, 'divibars_enable_scheduling' );
			$date_start = get_post_meta( $post->ID, 'divibars_date_start', true );
			$date_end = get_post_meta( $post->ID, 'divibars_date_end', true );
			$date_start = DiviBars_Admin::$helper->convertDateToUserTimezone( $date_start );
			$date_end = DiviBars_Admin::$helper->convertDateToUserTimezone( $date_end );
			
			$time_start = get_post_meta( $post->ID, 'divibars_time_start', true );
			$time_end = get_post_meta( $post->ID, 'divibars_time_end', true );
			
			$divibar_at_selected = get_post_meta( $post_id, 'divibars_automatictrigger', true );
			$divibar_ats = array(
				'divibar-timed'   => esc_html__( 'Timed Delay', 'DiviBars' ),
				'divibar-scroll'    => esc_html__( 'Scroll Percentage', 'DiviBars' ),
				'divibar-exit' => esc_html__( 'Exit Intent', 'DiviBars' ),
			);
			
			for( $a = 1; $a <= 7; $a++ ) {
				
				$daysofweek[$a] = get_post_meta( $post_id, 'divibars_scheduling_daysofweek_' . $a );
				
				if ( !isset( $daysofweek[$a][0] ) ) {
					
					$daysofweek[$a][0] = '0';
				}
				else {
					
					$daysofweek[$a] = $daysofweek[$a][0];
				}
			}
			
			if ( !isset( $disablemobile[0] ) ) {
				
				$disablemobile[0] = '0';
			}
			
			if ( !isset( $disabletablet[0] ) ) {
				
				$disabletablet[0] = '0';
			}
			
			if ( !isset( $disabledesktop[0] ) ) {
				
				$disabledesktop[0] = '0';
			}
			
			
			if ( !isset( $onceperload[0] ) ) {
				
				$onceperload[0] = '1';
			}
			
			if ( !isset( $enable_scheduling[0] ) ) {
				
				$enable_scheduling[0] = 0;
			}
			?>
			<p class="divi_automatictrigger_settings et_pb_single_title">
				<label for="post_divibar_automatictrigger"></label>
				<select id="post_divibar_automatictrigger" name="post_divibar_automatictrigger" class="post_divibar_automatictrigger chosen">
					<option value=""><?php esc_html_e( 'None', 'DiviBars' ); ?></option>
				<?php
				foreach ( $divibar_ats as $at_value => $at_name ) {
					printf( '<option value="%2$s"%3$s>%1$s</option>',
						esc_html( $at_name ),
						esc_attr( $at_value ),
						selected( $at_value, $divibar_at_selected, false )
					);
				} ?>
				</select>
			</p>
			
			<?php
			
				$at_timed = get_post_meta( $post->ID, 'divibars_automatictrigger_timed_value', true );
				$at_scroll_from = get_post_meta( $post->ID, 'divibars_automatictrigger_scroll_from_value', true );
				$at_scroll_to = get_post_meta( $post->ID, 'divibars_automatictrigger_scroll_to_value', true );
			?>
			<div class="divi_automatictrigger_timed<?php if ( $divibar_at_selected == 'divibar-timed' ) { ?> divibars-show<?php } ?>">
				<p>
					<label><?php esc_html_e( 'Specify timed delay (in seconds)', 'DiviBars' ) ?>:</label>
					<input class="post_at_timed" type="text" name="post_at_timed" value="<?php echo esc_attr( $at_timed ); ?>"/>
				</p>
				<div class="clear"></div> 
			</div>
			
			<div class="divi_automatictrigger_scroll<?php if ( $divibar_at_selected == 'divibar-scroll' ) { ?> divibars-show<?php } ?>">
				<p><?php esc_html_e( 'Specify in pixels or percentage', 'DiviBars' ) ?>:</p>
				<div class="at-scroll-settings">
					<label for="post_at_scroll_from"><?php esc_html_e( 'From', 'DiviBars' ) ?>:</label>
					<input class="post_at_scroll" type="text" name="post_at_scroll_from" value="<?php echo esc_attr( $at_scroll_from ); ?>"/>
					<label for="post_at_scroll_to"><?php esc_html_e( 'to', 'DiviBars' ) ?>:</label>
					<input class="post_at_scroll" type="text" name="post_at_scroll_to" value="<?php echo esc_attr( $at_scroll_to ); ?>"/>
				</div> 
				<div class="clear"></div> 
			</div>
			
			<div class="divilife_meta_box">
				<p>
					<input name="post_at_disablemobile" type="checkbox" id="post_at_disablemobile" value="1" <?php checked( $disablemobile[0], 1 ); ?> /> <?php esc_html_e( 'Disable On Mobile', 'DiviBars' ) ?>
				</p>
				<div class="clear"></div> 
			</div>
			
			<div class="divilife_meta_box">
				<p>
					<input name="post_at_disabletablet" type="checkbox" id="post_at_disabletablet" value="1" <?php checked( $disabletablet[0], 1 ); ?> /> <?php esc_html_e( 'Disable On Tablet', 'DiviBars' ) ?>
				</p>
				<div class="clear"></div> 
			</div>
			
			<div class="divilife_meta_box">
				<p>
					<input name="post_at_disabledesktop" type="checkbox" id="post_at_disabledesktop" value="1" <?php checked( $disabledesktop[0], 1 ); ?> /> <?php esc_html_e( 'Disable On Desktop', 'DiviBars' ) ?>
				</p>
				<div class="clear"></div> 
			</div>
			
			<div class="divilife_meta_box">
				<p>
					<input name="post_at_onceperload" type="checkbox" id="post_at_onceperload" value="1" <?php checked( $onceperload[0], 1 ); ?> />
					 <?php esc_html_e( 'Display once per page load', 'DiviBars' ) ?>
				</p>
				<div class="clear"></div> 
			</div>
			
			<div class="divilife_meta_box">
				<div class="divilife_meta_box">
					<p class="divibar_placement et_pb_single_title">
						<label for="dib_enable_scheduling"><?php esc_html_e( 'Set Scheduling', 'DiviBars' ) ?>:</label>
						<select name="dib_enable_scheduling" class="chosen divibars-enable-scheduling" data-dropdownshowhideblock="1">
							<option value="0"<?php if ( $enable_scheduling[0] == 0 ) { ?> selected="selected"<?php } ?>><?php esc_html_e( 'Disabled', 'DiviBars' ) ?></option>
							<option value="1"<?php if ( $enable_scheduling[0] == 1 ) { ?> selected="selected"<?php } ?> data-showhideblock=".dib-onetime">
							<?php esc_html_e( 'Start &amp; End Time', 'DiviBars' ) ?>
							</option>
							<option value="2"<?php if ( $enable_scheduling[0] == 2 ) { ?> selected="selected"<?php } ?> data-showhideblock=".dib-recurring">
							<?php esc_html_e( 'Recurring Scheduling', 'DiviBars' ) ?>
							</option>
						</select>
					</p>
				</div>
				
				<div class="row dib-onetime<?php if ( $enable_scheduling[0] == 1 ) { ?> divibars-show<?php } ?>">
					<div class="col-xs-12">
						<label>
							<?php esc_html_e( 'Start date', 'DiviBars' ) ?> <br/>
							<input type="text" name="dib_date_start" value="<?php print esc_attr( $date_start ); ?>" class="form-control">
						</label>
					</div>
					<div class="col-xs-12">
						<label>
							<?php esc_html_e( 'End date', 'DiviBars' ) ?> <br/>
							<input type="text" name="dib_date_end" value="<?php print esc_attr( $date_end ); ?>" class="form-control">
						</label>
					</div>
				</div>
				
				<div class="row dib-recurring<?php if ( $enable_scheduling[0] == 2 ) { ?> divibars-show<?php } ?>">
					<div class="col-xs-12">
						<p><input name="divibars_scheduling_daysofweek[]" type="checkbox" id="divibars_scheduling_daysofweek" value="1" <?php checked( $daysofweek[1][0], 1 ); ?> /> <?php esc_html_e( 'Monday', 'DiviBars' ) ?></p>
						<p><input name="divibars_scheduling_daysofweek[]" type="checkbox" id="divibars_scheduling_daysofweek" value="2" <?php checked( $daysofweek[2][0], 1 ); ?> /> <?php esc_html_e( 'Tuesday', 'DiviBars' ) ?></p>
						<p><input name="divibars_scheduling_daysofweek[]" type="checkbox" id="divibars_scheduling_daysofweek" value="3" <?php checked( $daysofweek[3][0], 1 ); ?> /> <?php esc_html_e( 'Wednesday', 'DiviBars' ) ?></p>
						<p><input name="divibars_scheduling_daysofweek[]" type="checkbox" id="divibars_scheduling_daysofweek" value="4" <?php checked( $daysofweek[4][0], 1 ); ?> /> <?php esc_html_e( 'Thursday', 'DiviBars' ) ?></p>
						<p><input name="divibars_scheduling_daysofweek[]" type="checkbox" id="divibars_scheduling_daysofweek" value="5" <?php checked( $daysofweek[5][0], 1 ); ?> /> <?php esc_html_e( 'Friday', 'DiviBars' ) ?></p>
						<p><input name="divibars_scheduling_daysofweek[]" type="checkbox" id="divibars_scheduling_daysofweek" value="6" <?php checked( $daysofweek[6][0], 1 ); ?> /> <?php esc_html_e( 'Saturday', 'DiviBars' ) ?></p>
						<p><input name="divibars_scheduling_daysofweek[]" type="checkbox" id="divibars_scheduling_daysofweek" value="7" <?php checked( $daysofweek[7][0], 1 ); ?> /> <?php esc_html_e( 'Sunday', 'DiviBars' ) ?></p>
					</div>
					<div class="col-sm-6">
						<label>
							<?php esc_html_e( 'Start Time', 'DiviBars' ) ?> <br/>
							<input type="text" name="dib_time_start" value="<?php print esc_attr( $time_start ); ?>" class="form-control">
						</label>
						<div id="datetimepicker12"></div>
					</div>
					<div class="col-sm-6">
						<label>
							<?php esc_html_e( 'End Time', 'DiviBars' ) ?> <br/>
							<input type="text" name="dib_time_end" value="<?php print esc_attr( $time_end ); ?>" class="form-control">
						</label>
					</div>
				</div>
				
				<div class="row">
					<div class="col-xs-12">
						<div class="dib-recurring-user-msg alert alert-danger">
							
						</div>
					</div>
				</div>
				
				<div class="clear"></div> 
			</div>
			
			<?php
		}
		
		
		public static function save_post( $post_id, $post ) {
			
			global $pagenow;
			
			// Only set for post_type = DiviBars
			if ( 'divi_bars' !== $post->post_type ) {
				return;
			}

			if ( 'post.php' !== $pagenow ) return $post_id;

			if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE )
				return $post_id;

			$post_type = get_post_type_object( $post->post_type );
			if ( ! current_user_can( $post_type->cap->edit_post, $post_id ) )
				return $post_id;
			
			if ( !isset( $_POST['divibars_displaylocations_nonce'] ) ) {
				
				return;
			}
			
			$nonce = sanitize_text_field( wp_unslash( $_POST['divibars_displaylocations_nonce'] ) );
			if ( ! wp_verify_nonce( $nonce, 'divibars_displaylocations' ) ) {
				
				 die(); 
			}
			
			$post_value = '';
			
			$post_at_pages = '';
			
			
			/* Display Locations */
			if ( isset( $_POST['post_at_pages'] ) ) {
				
				$post_at_pages = sanitize_option( 'at_pages', wp_unslash( $_POST['post_at_pages'] ) );
				update_post_meta( $post_id, 'at_pages', $post_at_pages );
			}
			
			if ( $post_at_pages == 'specific' ) {
				
				if ( isset( $_POST['post_at_pages_selected'] ) ) {
					
					$post_value = sanitize_option( 'at_pages_selected', wp_unslash( $_POST['post_at_pages_selected'] ) );
					update_post_meta( $post_id, 'at_pages_selected', $post_value );
				}
			}
			else {
				
				update_post_meta( $post_id, 'at_pages_selected', '' );
			}
			
			if ( isset( $_POST['post_at_exceptionpages_selected'] ) ) {
			
				$post_value = sanitize_option( 'at_pagesexception_selected', wp_unslash( $_POST['post_at_exceptionpages_selected'] ) );
				update_post_meta( $post_id, 'at_pagesexception_selected', $post_value );
			}
			else {
				
				update_post_meta( $post_id, 'at_pagesexception_selected', '' );
			}
			
			
			/* By Categories */
			$category_at_categories = '';
			if ( isset( $_POST['divibars_category_at_categories'] ) ) {
				
				$category_at_categories = sanitize_option( 'divibars_category_at_categories', wp_unslash( $_POST['divibars_category_at_categories'] ) );
				update_post_meta( $post_id, 'divibars_category_at_categories', $category_at_categories );
			}
			
			if ( $category_at_categories == 'specific' ) {
				
				if ( isset( $_POST['divibars_category_at_categories_selected'] ) ) {
					
					$post_value = sanitize_option( 'divibars_category_at_categories_selected', wp_unslash( $_POST['divibars_category_at_categories_selected'] ) );
					update_post_meta( $post_id, 'divibars_category_at_categories_selected', $post_value );
				}
			}
			else {
				
				update_post_meta( $post_id, 'divibars_category_at_categories_selected', '' );
			}
			
			if ( isset( $_POST['divibars_category_at_exceptioncategories_selected'] ) ) {

				$post_value = sanitize_option( 'divibars_category_at_exceptioncategories_selected', wp_unslash( $_POST['divibars_category_at_exceptioncategories_selected'] ) );
				update_post_meta( $post_id, 'divibars_category_at_exceptioncategories_selected', $post_value );
			}
			else {
				
				update_post_meta( $post_id, 'divibars_category_at_exceptioncategories_selected', '' );
			}
			
			/* By Tags */
			$tag_at_tags = '';
			if ( isset( $_POST['divibars_tag_at_tags'] ) ) {
				
				$tag_at_tags = sanitize_option( 'divibars_tag_at_tags', wp_unslash( $_POST['divibars_tag_at_tags'] ) );
				update_post_meta( $post_id, 'divibars_tag_at_tags', $tag_at_tags );
			}
			
			if ( $tag_at_tags == 'specific' ) {
				
				if ( isset( $_POST['divibars_tag_at_tags_selected'] ) ) {
					
					$post_value = sanitize_option( 'divibars_tag_at_tags_selected', wp_unslash( $_POST['divibars_tag_at_tags_selected'] ) );
					update_post_meta( $post_id, 'divibars_tag_at_tags_selected', $post_value );
				}
			}
			else {
				
				update_post_meta( $post_id, 'divibars_tag_at_tags_selected', '' );
			}
			
			if ( isset( $_POST['divibars_tag_at_exceptiontags_selected'] ) ) {

				$post_value = sanitize_option( 'divibars_tag_at_exceptiontags_selected', wp_unslash( $_POST['divibars_tag_at_exceptiontags_selected'] ) );
				update_post_meta( $post_id, 'divibars_tag_at_exceptiontags_selected', $post_value );
			}
			else {
				
				update_post_meta( $post_id, 'divibars_tag_at_exceptiontags_selected', '' );
			}
			
			/* By Archive */
			if ( isset( $_POST['divibars_displaylocations_archive'] ) ) {
				
				$divibars_displaylocations_archive = 1;
				
			} else {
				
				$divibars_displaylocations_archive = 0;
			}
			update_post_meta( $post_id, 'divibars_displaylocations_archive', $divibars_displaylocations_archive );
			
			/* By Author */
			if ( isset( $_POST['divibars_displaylocations_author'] ) ) {
				
				$divibars_displaylocations_author = 1;
				
			} else {
				
				$divibars_displaylocations_author = 0;
			}
			update_post_meta( $post_id, 'divibars_displaylocations_author', $divibars_displaylocations_author );
			
			/* By Force render */
			if ( isset( $_POST['divibars_displaylocations_forcerender'] ) ) {
				
				$divibars_displaylocations_forcerender = 1;
				
			} else {
				
				$divibars_displaylocations_forcerender = 0;
			}
			update_post_meta( $post_id, 'divibars_displaylocations_forcerender', $divibars_displaylocations_forcerender );
			
			
			/* Additional Settings */
			if ( isset( $_POST['dib_css_selector'] ) ) {
				
				$post_value = sanitize_text_field( wp_unslash( $_POST['dib_css_selector'] ) );
				update_post_meta( $post_id, 'dib_css_selector', $post_value );
			}
			
			if ( isset( $_POST['dib_post_placement'] ) ) {
				
				$post_value = sanitize_text_field( wp_unslash( $_POST['dib_post_placement'] ) );
				update_post_meta( $post_id, 'dib_post_placement', $post_value );
			}
			
			if ( isset( $_POST['post_pushpage'] ) ) {
				
				$post_pushpage = 1;
				
			} else {
				
				$post_pushpage = 0;
			}
			update_post_meta( $post_id, 'post_pushpage', $post_pushpage );
			
			
			if ( isset( $_POST['dib_enableurltrigger'] ) ) {
				
				$dib_enableurltrigger = 1;
				
			} else {
				
				$dib_enableurltrigger = 0;
			}
			update_post_meta( $post_id, 'dib_enableurltrigger', $dib_enableurltrigger );
			
			if ( isset( $_POST['divibars_showguests'] ) ) {
				
				$divibars_showguests = 1;
				
			} else {
				
				$divibars_showguests = 0;
			}
			update_post_meta( $post_id, 'divibars_showguests', $divibars_showguests );
			
			
			if ( isset( $_POST['divibars_showusers'] ) ) {
				
				$divibars_showusers = 1;
				
			} else {
				
				$divibars_showusers = 0;
			}
			update_post_meta( $post_id, 'divibars_showusers', $divibars_showusers );
			
			
			if ( isset( $_POST['post_screenfixed'] ) ) {
				
				$post_screenfixed = 1;
				
			} else {
				
				$post_screenfixed = 0;
			}
			update_post_meta( $post_id, 'post_screenfixed', $post_screenfixed );
			
			
			if ( isset( $_POST['post_divibar_automatictrigger'] ) ) {
				
				$post_value = sanitize_text_field( wp_unslash( $_POST['post_divibar_automatictrigger'] ) );
				update_post_meta( $post_id, 'divibars_automatictrigger', $post_value );
			
				if ( isset( $_POST['post_at_timed'] ) ) {
					
					$post_value = sanitize_text_field( wp_unslash( $_POST['post_at_timed'] ) );
					update_post_meta( $post_id, 'divibars_automatictrigger_timed_value', $post_value );
				}
				
				if ( isset( $_POST['post_at_scroll_from'] ) || isset( $_POST['post_at_scroll_to'] ) ) {
					
					$post_value = sanitize_text_field( wp_unslash( $_POST['post_at_scroll_from'] ) );
					update_post_meta( $post_id, 'divibars_automatictrigger_scroll_from_value', $post_value );
					
					$post_value = sanitize_text_field( wp_unslash( $_POST['post_at_scroll_to'] ) );
					update_post_meta( $post_id, 'divibars_automatictrigger_scroll_to_value', $post_value );
				}
				
				if ( isset( $_POST['post_at_disablemobile'] ) ) {
					
					$post_at_disablemobile = 1;
					
				} else {
					
					$post_at_disablemobile = 0;
				}
				
				if ( isset( $_POST['post_at_disabletablet'] ) ) {
					
					$post_at_disabletablet = 1;
					
				} else {
					
					$post_at_disabletablet = 0;
				}
				
				if ( isset( $_POST['post_at_disabledesktop'] ) ) {
					
					$post_at_disabledesktop = 1;
					
				} else {
					
					$post_at_disabledesktop = 0;
				}
				
				if ( isset( $_POST['post_at_onceperload'] ) ) {
					
					$post_at_onceperload = 1;
					
				} else {
					
					$post_at_onceperload = 0;
				}
				
				update_post_meta( $post_id, 'divibars_automatictrigger_onceperload', $post_at_onceperload );
				
			} else {
				
				$post_at_disablemobile = 0;
				$post_at_disabletablet = 0;
				$post_at_disabledesktop = 0;
			}
			update_post_meta( $post_id, 'divibars_automatictrigger_disablemobile', $post_at_disablemobile );
			update_post_meta( $post_id, 'divibars_automatictrigger_disabletablet', $post_at_disabletablet );
			update_post_meta( $post_id, 'divibars_automatictrigger_disabledesktop', $post_at_disabledesktop );
			
			/* Close Button Customizations */
			if ( isset( $_POST['post_closebtn_cookie'] ) ) {
				
				$post_value = sanitize_text_field( wp_unslash( $_POST['post_closebtn_cookie'] ) );
				update_post_meta( $post_id, 'post_closebtn_cookie', $post_value );
			}
			
			if ( isset( $_POST['post_do_hideclosebtn'] ) ) {
				
				$post_do_hideclosebtn = 1;
				
			} else {
				
				$post_do_hideclosebtn = 0;
			}
			update_post_meta( $post_id, 'post_do_hideclosebtn', $post_do_hideclosebtn );
			
			if ( isset( $_POST['post_do_customizeclosebtn'] ) ) {
				
				$post_do_customizeclosebtn = 1;
				
			} else {
				
				$post_do_customizeclosebtn = 0;
			}
			update_post_meta( $post_id, 'post_do_customizeclosebtn', $post_do_customizeclosebtn );
			
			if ( isset( $_POST['post_closebtn_text_color'] ) ) {
				
				$post_value = sanitize_text_field( wp_unslash( $_POST['post_closebtn_text_color'] ) );
				update_post_meta( $post_id, 'post_closebtn_text_color', $post_value );
			}
			
			if ( isset( $_POST['post_closebtn_bg_color'] ) ) {
				
				$post_value = sanitize_text_field( wp_unslash( $_POST['post_closebtn_bg_color'] ) );
				update_post_meta( $post_id, 'post_closebtn_bg_color', $post_value );
			}
			
			if ( isset( $_POST['post_closebtn_fontsize'] ) ) {
				
				$post_value = sanitize_text_field( wp_unslash( $_POST['post_closebtn_fontsize'] ) );
				update_post_meta( $post_id, 'post_closebtn_fontsize', $post_value );
			}
			
			if ( isset( $_POST['post_closebtn_borderradius'] ) ) {
				
				$post_value = sanitize_text_field( wp_unslash( $_POST['post_closebtn_borderradius'] ) );
				update_post_meta( $post_id, 'post_closebtn_borderradius', $post_value );
			}
			
			if ( isset( $_POST['post_closebtn_padding'] ) ) {
				
				$post_value = sanitize_text_field( wp_unslash( $_POST['post_closebtn_padding'] ) );
				update_post_meta( $post_id, 'post_closebtn_padding', $post_value );
			}
			
			if ( isset( $_POST['dib_enable_scheduling'] ) ) {
				
				$enable_scheduling = (int) $_POST['dib_enable_scheduling'];
				
			} else {
				
				$enable_scheduling = 0;
			}
			update_post_meta( $post_id, 'divibars_enable_scheduling', $enable_scheduling );
			
			/* Save Scheduling */
			if ( $enable_scheduling ) {
				
				$timezone = DIVI_SERVER_TIMEZONE;
				
				$wp_timezone = wp_timezone();
				
				if ( $wp_timezone !== false ) {
					
					$timezone = $wp_timezone;
				}
				
				if ( $enable_scheduling == 1 ) {
					
					if ( isset( $_POST['dib_date_start'] ) ) {
						
						$post_value = sanitize_text_field( wp_unslash( $_POST['dib_date_start'] ) );
						
						$date_string = DiviBars_Admin::$helper->convertDateToUTC( $post_value, $timezone );
						
						update_post_meta( $post_id, 'divibars_date_start', sanitize_text_field( $date_string ) );
					}
					
					if ( isset( $_POST['dib_date_end'] ) ) {
						
						$post_value = sanitize_text_field( wp_unslash( $_POST['dib_date_end'] ) );
						
						$date_string = DiviBars_Admin::$helper->convertDateToUTC( $post_value, $timezone );
						
						update_post_meta( $post_id, 'divibars_date_end', sanitize_text_field( $date_string ) );
					}
				}
				
				if ( $enable_scheduling == 2 ) {
					
					if ( isset( $_POST['dib_time_start'] ) ) {
						
						$post_value = sanitize_text_field( wp_unslash( $_POST['dib_time_start'] ) );
						
						update_post_meta( $post_id, 'divibars_time_start', $post_value );
					}
					
					if ( isset( $_POST['dib_time_end'] ) ) {
						
						$post_value = sanitize_text_field( wp_unslash( $_POST['dib_time_end'] ) );
						
						update_post_meta( $post_id, 'divibars_time_end', $post_value );
					}
					
					if ( isset( $_POST['divibars_scheduling_daysofweek'] ) ) {
						
						$daysofweek = map_deep( wp_unslash( $_POST['divibars_scheduling_daysofweek'] ), 'sanitize_text_field' );
						
						// Reset all daysofweek values
						for( $a = 1; $a <= 7; $a++ ) {
							update_post_meta( $post_id, 'divibars_scheduling_daysofweek_' . $a, 0 );
						}
						
						foreach( $daysofweek as $day ) {
							update_post_meta( $post_id, 'divibars_scheduling_daysofweek_' . $day, 1);
						}
					}
				}
			}
			
			// Clear all Divi cache
			DiviBars_Admin::super_clear_cache();
			
			return $post_id;
		}
		
		public static function save_post_not_divibars( $post_id, $post ) {
			
			global $pagenow;
			
			if ( 'post.php' !== $pagenow ) return $post_id;
			
			if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE )
				return $post_id;
			
			$post_type = get_post_type_object( $post->post_type );
			if ( ! current_user_can( $post_type->cap->edit_post, $post_id ) )
				return $post_id;
			
			// Clear all Divi cache
			DiviBars_Admin::super_clear_cache();
		}
		
		
		public static function add_admin_submenu() {
			
			$settings_page = 'divilife_edd_divibars_license';
			
			$pass = true;
			
			if ( DIVI_BARS_UPDATER === TRUE ) {
				
				$pass = false;
				
				if ( isset( $_POST['option_page'] ) ) {
					
					$option_page = sanitize_text_field( wp_unslash( $_POST['option_page'] ) );
					
					if ( $option_page === $settings_page && isset( $_POST['action'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification.NoNonceVerification -- logic for nonce checks are below
					
						$pass = true;
					}
				}
			}
			
			if ( $pass === true ) {
				
				if ( isset( $_POST['_wpnonce'] ) ) {
					
					$wpnonce = sanitize_text_field( wp_unslash( $_POST['_wpnonce'] ) );
					
					if ( wp_verify_nonce( $wpnonce, 'dib_nonce' ) ) {
						
						self::dib_save_data();
					}
				}
			}
			
			// Admin page
			add_submenu_page( 'edit.php?post_type=divi_bars', 'Divi Bars', 'Settings', 'edit_posts', 'divibars-settings', array( 'DiviBars_Admin_Controller', 'admin_settings' ) );
		}
		
		
		public static function admin_settings() {
			
			add_action( 'admin_init', 'et_epanel_css_admin' );
			
			self::display_configuration_page();
		}
		
		
		private static function dib_save_data() {
			
			check_admin_referer( 'dib_nonce' );

			if ( ! current_user_can( 'edit_theme_options' ) ) {
				wp_die();
			}
			
			if ( isset( $_POST['dib_custom_elems'] ) ) {
				
				$dib_custom_elems = sanitize_text_field( wp_unslash( $_POST['dib_custom_elems'] ) );
				$dib_custom_elems = array( 'dib_custom_elems' => $dib_custom_elems );
				
				update_option( 'dib_settings', $dib_custom_elems );
			}
			
			if ( DIVI_BARS_UPDATER === TRUE ) {
				
				if ( isset( $_POST['divilife_edd_divibars_license_key'] ) && $_POST['divilife_edd_divibars_license_key'] !== '*******' ) {
					
					$license_key = '';
					
					if ( isset( $_POST['divilife_edd_divibars_license_key'] ) ) {
						
						$license_key = sanitize_text_field( wp_unslash( $_POST['divilife_edd_divibars_license_key'] ) );
					}
					
					if ( strlen( $license_key ) > 25 ) {
						
						update_option( 'divilife_edd_divibars_license_key', $license_key );
						
						divilife_edd_divibars_activate_license();
					}
					else {
						
						update_option( 'divilife_edd_divibars_license_key', '' );
						update_option( 'divilife_edd_divibars_license_status', '' );
						
						divilife_edd_divibars_deactivate_license();
					}
				}
			}
			
			$base_url = admin_url( 'edit.php?post_type=divi_bars&page=divibars-settings' );
			
			$redirect = add_query_arg( array( 'divilife' => 'divibars' ), $base_url );
			
			wp_safe_redirect( $redirect );
			exit();
		}
		
		
		public static function display_configuration_page() {
			
			DiviBars_Admin::$options = get_option( 'dib_settings' );
			
			$dib_custom_elems = '';
			
			if ( isset( DiviBars_Admin::$options['dib_custom_elems'] ) ) {
				
				$dib_custom_elems = DiviBars_Admin::$options['dib_custom_elems'];
			}
			
			if ( DIVI_BARS_UPDATER === TRUE ) {
			
				$license = get_option( 'divilife_edd_divibars_license_key' );
				$status  = get_option( 'divilife_edd_divibars_license_status' );
				$check_license = divilife_edd_divibars_check_license( TRUE );
				
				if ( $license != '' ) {
					
					$license = '*******';
				}
				
				$daysleft = 0;
				
				if ( isset( $check_license->expires ) && $check_license->expires != 'lifetime' ) {
					
					$license_expires = strtotime( $check_license->expires );
					$now = strtotime('now');
					$timeleft = $license_expires - $now;
					
					$daysleft = round( ( ( $timeleft / 24 ) / 60 ) / 60 );
					if ( $daysleft > 0 ) {
						
						$daysleft = '( ' . ( ( $daysleft > 1 ) ? $daysleft . ' days left' : $daysleft . ' day left' ) . ' )';
						
					} else {
						
						$daysleft = '';
					}
				}
			}
			
			?>
		<div id="wrapper">
		  <div id="panel-wrap">
		  
				<form method="post" action="options.php">
				
					<div id="epanel-wrapper">
						<div id="epanel" class="et-onload">
							<div id="epanel-content-wrap">
								<div id="epanel-header" class="ui-tabs ui-widget ui-widget-content ui-corner-all">
									<h1 id="epanel-title"><?php esc_html_e('Divi Bars - Settings', 'DiviBars' ); ?></h1>
								</div>
								<div id="epanel-content">
								
									<div class="et-tab-content ui-widget-content ui-corner-bottom" aria-hidden="false">
									
										<div class="et-epanel-box">
										<?php settings_fields( 'divibars_settings' ); ?>
										
											<div class="et-box-title"><h3><?php esc_html_e('Custom Elements CSS Selector', 'DiviBars' ); ?></h3></div>
											<div class="et-box-content">
												<label class="description" for="dib_custom_elems"></label>
												<input id="dib_custom_elems" name="dib_custom_elems" type="text" class="regular-text" value="<?php esc_attr_e( $dib_custom_elems ); ?>" />
											</div>
										</div>
										
									<?php if ( DIVI_BARS_UPDATER === TRUE ) { ?>
										
										<div class="et-epanel-box">
											<?php settings_fields('divilife_edd_divibars_license', 'DiviBars' ); ?>

											<div class="et-box-title"><h3><?php esc_html_e('License Key', 'DiviBars' ); ?></h3></div>
											<div class="et-box-content">
												<label class="description" for="divilife_edd_divibars_license_key"></label>
												<input id="divilife_edd_divibars_license_key" name="divilife_edd_divibars_license_key" type="text" class="regular-text" value="<?php esc_attr_e( $license ); ?>" />
											</div>
										</div>
										
										<?php if ( FALSE !== $license && $check_license->license != 'invalid' ) { ?>
										
											<div class="et-epanel-box">
												<div class="et-box-title"><h3><?php esc_html_e('License Status', 'DiviBars' ); ?></h3></div>
												<div class="et-box-content">
													<?php 
														if ( $status !== false && $check_license->license == 'valid' ) {
															
															print '
															<p class="inputs"><span class="jquery-checkbox"><span class="mark"></span></span></p><br><br>';
														}
														else {
															
															if ( $check_license->license == 'expired' ) {
															
																print '<span class="dashicons dashicons-no-alt dashicons-fail dashicons-large"></span>';
																print '&nbsp;&nbsp;<span class="small-text">( Expired on ' . gmdate( 'F d, Y', strtotime( $check_license->expires ) ) . ' )</span>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
															}
															
															if ( $check_license->license == NULL && $status !== false ) {
																
																print '<span class="dashicons dashicons-no-alt dashicons-fail dashicons-large"></span>';
																print '&nbsp;&nbsp;<span class="small-text">( Cannot retrieve license status from Divi Life server. Please contact Divi Life support. )</span>';
															}
														}
													?>
												</div>
											</div>
											<?php
											
											if ( $status !== false ) { 
												
												if ( $daysleft != '' && $check_license->license == 'valid' ) { ?>
												<div class="et-epanel-box">
													<div class="et-box-title"><h3><?php esc_html_e('License Expires on', 'DiviBars' ); ?></h3></div>
													<div class="et-box-content">
														<h4 class="no-margin">
															<?php print esc_html__( gmdate( 'F d, Y', strtotime( $check_license->expires ) ) ); ?>
															<?php print esc_html__( $daysleft ); ?>
														</h4>
													</div>
												</div>
												<?php
												}
											}
											?>
										
										<?php } ?>
										
									<?php } ?>
										
									</div>
					
								</div> <!-- end epanel-content div -->
							</div> <!-- end epanel-content-wrap div -->
						</div> <!-- end epanel div -->
					</div> <!-- end epanel-wrapper div -->
					
					<div id="epanel-bottom">
						<?php wp_nonce_field( 'dib_nonce' ); ?>
						<button class="et-save-button" name="dib_save" id="dib-save"><?php esc_html_e( 'Save Changes', 'DiviBars' ); ?></button>
					</div>

				</form>
				
			</div> <!-- end panel-wrap div -->
		</div> <!-- end wrapper div -->
			<?php
		
		}
		
	} // end DiviBars_Admin_Controller