<?php
/*
Plugin Name: Divi Bars
Plugin URL: https://divilife.com/
Description: Create slide-in promo bars using the Divi Builder.
Version: 1.9.0.1
Author: Divi Life — Tim Strifler
Author URI: https://divilife.com
*/

// Make sure we don't expose any info if called directly or may someone integrates this plugin in a theme
if ( class_exists('DiviBars') || !defined('ABSPATH') || !function_exists( 'add_action' ) ) {
	
	return;
}

$all_plugins = apply_filters( 'active_plugins', get_option( 'active_plugins' ) );

$current_theme = wp_get_theme();

function dib_divibuilder_required() {
	
	$class = 'notice notice-error';
	$message = __( 'Divi Mega Pro requires: Divi Builder', 'DiviMegaPro' );
	
	printf( '<div class="%1$s"><p>%2$s</p></div>', esc_attr( $class ), esc_html( $message ) );
}

if ( ( $current_theme->get( 'Name' ) !== 'Divi' && $current_theme->get( 'Template' ) !== 'Divi' ) 
	&& ( $current_theme->get( 'Name' ) !== 'Extra' && $current_theme->get( 'Template' ) !== 'Extra' )
	&& apply_filters( 'divi_ghoster_ghosted_theme', get_option( 'agsdg_ghosted_theme' ) ) !== 'Divi' ) {
	
	if ( stripos( implode( $all_plugins ), 'divi-builder.php' ) === false ) {
		
		add_action( 'admin_notices', 'dib_divibuilder_required' );
		
		return;
	}
}

define( 'DIVI_BARS_VERSION', '1.9.0.1');
define( 'DIVI_BARS_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );
define( 'DIVI_BARS_PLUGIN_NAME', trim( dirname( DIVI_BARS_PLUGIN_BASENAME ), '/' ) );
define( 'DIVI_BARS_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'DIVI_BARS_PLUGIN_URL', plugin_dir_url( __FILE__ ));
define( 'DIVI_SERVER_TIMEZONE', 'UTC');
define( 'DIVI_SCHEDULING_DATETIME_FORMAT', 'm\/d\/Y g:i A');

require_once( DIVI_BARS_PLUGIN_DIR . '/class.divi-bars.core.php' );

add_action( 'init', array( 'DiviBars', 'init' ) );


register_deactivation_hook( __FILE__, 'flush_rewrite_rules' );
register_activation_hook( __FILE__, 'divibars_flush_rewrites' );
function divibars_flush_rewrites() {
	
	DiviBars::register_cpt();
	flush_rewrite_rules();
}

if ( is_admin() ) {
	
	require_once( DIVI_BARS_PLUGIN_DIR . '/class.divi-bars.admin.core.php' );
	add_action( 'init', array( 'DiviBars_Admin', 'init' ) );
	
	$edd_updater = DIVI_BARS_PLUGIN_DIR . 'updater.php';
	$edd_updater_admin = DIVI_BARS_PLUGIN_DIR . 'updater-admin.php';

	if ( file_exists( $edd_updater ) && file_exists( $edd_updater_admin ) ) {

		// Load the API Key library if it is not already loaded
		if ( ! class_exists( 'edd_divimegapro' ) ) {
			
			require_once( $edd_updater );
			require_once( $edd_updater_admin );
		}
		
		define( 'DIVI_BARS_UPDATER', TRUE );
	}
	else {
		
		define( 'DIVI_BARS_UPDATER', FALSE );
	}
}
