<?php

	class DiviBars {
		
		private static $initiated = false;
		
		/**
		 * Holds an instance of DiviBars Helper class
		 *
		 * @since 1.0
		 * @var DiviBars_Helper
		 */
		public static $helper;
		
		protected static $divibarsList;
		
		protected static $isMobileDevice = false;
		
		protected static $isTabletDevice = false;
		
		public static function init() {
			
			if ( ! self::$initiated ) {
				
				self::load_resources();
				
				self::$helper = new DiviBars_Helper();
				
				self::init_hooks();
				
				// Register the Custom Divi Bar Post Type
				self::register_cpt();
				
				self::enable_divicpt_option();
			}
		}
		
		/**
		 * Initializes WordPress hooks
		 */
		protected static function init_hooks() {
			
			self::$initiated = true;
			
			// Register widget
			add_action( 'widgets_init', array( 'DiviBars', 'register_widget') );
			
			$pos = false;
			// Check if this was called from License page
			if ( isset( $_SERVER['HTTP_REFERER'] ) ) {
				
				$referer = sanitize_text_field( wp_unslash( $_SERVER['HTTP_REFERER'] ) );

				$pos = strpos( $referer, 'page=divibars-settings' );
			}
			
			// This is not required on post edit or license page
			if ( !is_admin() && !self::is_divi_builder_enabled() && $pos === false ) {
			
				// Add styles
				add_action( 'wp_print_styles', array( 'DiviBars', 'add_styles') );
				
				// Ajax ready
				add_action( 'wp_head', array( 'DiviBars', 'add_var_ajaxurl') );
				add_action( 'wp_ajax_ajax_divibars_callback', array( 'DiviBars_Ajax', 'ajax_divibars_callback') );
				add_action( 'wp_ajax_nopriv_ajax_divibars_callback', array( 'DiviBars_Ajax', 'ajax_divibars_callback') );
				
				// Check for possible required dependencies
				add_action( 'wp_head', array( 'DiviBars', 'getAllDivibars'), 7 );
				add_action( 'wp_head', array( 'DiviBars', 'checkAllDiviBars'), 8 );
				
				add_action( 'wp_head', array( 'DiviBars', 'addActionFilters'), 11 );
			}
		}
		
		
		public static function addActionFilters() {
			
			add_action( 'wp_body_open', array( 'DiviBars_Controller', 'addDiviBars' ), 10 );
		}
		
		
		protected static function load_wc_scripts() {
			
			if ( ! class_exists( 'WC_Frontend_Scripts' ) && function_exists( 'et_core_is_fb_enabled' ) && ! et_core_is_fb_enabled() ) {
				return;
			}
			
			// Simply enqueue the scripts; All of them have been registered
			if ( 'yes' === get_option( 'woocommerce_enable_ajax_add_to_cart' ) ) {
				wp_enqueue_script( 'wc-add-to-cart' );
			}
			
			if ( current_theme_supports( 'wc-product-gallery-zoom' ) ) {
				wp_enqueue_script( 'zoom' );
			}
			if ( current_theme_supports( 'wc-product-gallery-slider' ) ) {
				wp_enqueue_script( 'flexslider' );
			}
			if ( current_theme_supports( 'wc-product-gallery-lightbox' ) ) {
				wp_enqueue_script( 'photoswipe-ui-default' );
				wp_enqueue_style( 'photoswipe-default-skin' );
				
				add_action( 'wp_footer', 'woocommerce_photoswipe' );
			}
			wp_enqueue_script( 'wc-single-product' );
			
			if ( 'geolocation_ajax' === get_option( 'woocommerce_default_customer_address' ) ) {
				$ua = strtolower( wc_get_user_agent() ); // Exclude common bots from geolocation by user agent.
				
				if ( ! strstr( $ua, 'bot' ) && ! strstr( $ua, 'spider' ) && ! strstr( $ua, 'crawl' ) ) {
					wp_enqueue_script( 'wc-geolocation' );
				}
			}
			
			wp_enqueue_script( 'woocommerce' );
			wp_enqueue_script( 'wc-cart-fragments' );
			
			// Enqueue style
			$wc_styles = WC_Frontend_Scripts::get_styles();
			
			foreach ( $wc_styles as $style_handle => $wc_style ) {
				if ( ! isset( $wc_style['has_rtl'] ) ) {
					$wc_style['has_rtl'] = false;
				}
				
				wp_enqueue_style( $style_handle, $wc_style['src'], $wc_style['deps'], $wc_style['version'], $wc_style['media'], $wc_style['has_rtl'] );
			}
		}
		
		
		public static function checkAllDiviBars() {
			
			$render = false;
			$divibars_in_current = DiviBars_Controller::addDiviBars( '', $render );
			
			$classes = get_body_class();
			
			if ( !in_array( 'woocommerce', $classes ) 
				&& !in_array( 'woocommerce-page', $classes ) 
				&& function_exists( 'et_builder_has_woocommerce_module' ) ) {
				
				if ( is_array( $divibars_in_current ) && count( $divibars_in_current ) > 0 ) {
					
					foreach( $divibars_in_current as $divibar_id ) {
					
						$divibar_id = (int) $divibar_id;
						
						$post = get_post( $divibar_id );
						
						$has_wc_module = et_builder_has_woocommerce_module( $post->post_content );
						
						if ( $has_wc_module === true ) {
							
							add_filter( 'body_class', function( $classes ) {
								
								$classes[] = 'woocommerce';
								$classes[] = 'woocommerce-page';
								
								return $classes;
							} );
							
							// Load WooCommerce related scripts
							self::load_wc_scripts();
							
							return;
						}
					}
				}
			}
			
			
			// Support Slider Revolution by ThemePunch
			// Reset global vars to prevent any conflicts
			global $rs_material_icons_css, $rs_material_icons_css_parsed;
			
			$rs_material_icons_css = false;
			$rs_material_icons_css_parsed = false;
			
			
			// Support Gravity Forms Styles Pro
			// Restore dequeue Gravity Forms styles
			wp_enqueue_style( 'gforms_css' );
			wp_enqueue_style( 'gforms_reset_css' );
			wp_enqueue_style( 'gforms_formsmain_css' );
			wp_enqueue_style( 'gforms_ready_class_css' );
			wp_enqueue_style( 'gforms_browsers_css' );
			
			add_filter( 'et_pb_set_style_selector', array( 'DiviBars', 'et_pb_set_style_selector' ), 10, 2 );
		}
		
		public static function et_pb_set_style_selector( $selector, $function_name ) {
			
			// Extra theme support
			if ( function_exists( 'extra_layout_used' ) ) {
			
				// List of module slugs that need to be prefixed
				$prefixed_modules = apply_filters( 'extra_layout_prefixed_selectors', array(
					'et_pb_section',
					'et_pb_row',
					'et_pb_row_inner',
					'et_pb_column',
				));
								
				// Prefixing selectors in Extra layout
				if ( extra_layout_used() || ( is_et_pb_preview() && isset( $_GET['is_extra_layout'] ) ) && in_array( $function_name, $prefixed_modules ) ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
					if ( 'default' === ET_Builder_Element::get_theme_builder_layout_type() ) {
						
						$extra_extra_db = '.et_extra_layout .et_pb_extra_column_main .et-db ';
						$extra_extra_without_db = '.et_extra_layout .et_pb_extra_column_main '; 
						
						if ( $extra_extra_db === substr( $selector, 0, 49 ) ) {
							
							$selector = str_replace( $extra_extra_db, $extra_extra_without_db, $selector );
						}
						
						$extra_extra_bodydb = '.et_extra_layout .et_pb_extra_column_main body.et-db ';
						$extra_extra_without_bodydb = '.et_extra_layout ';
						
						if ( $extra_extra_bodydb === substr( $selector, 0, 53 ) ) {
							
							$selector = str_replace( $extra_extra_bodydb, $extra_extra_without_bodydb, $selector );
						}
					}
				}
			}
			
			return $selector;
		}
		
		
		public static function getAllDivibars() {
			
			$function_exception = 'addDiviBars';
			
			$divibars = array();
			
			try {
			
				/* Search Divi divibar in current post */
				global $post;
				
				$divibars_in_post = array();
				
				if ( is_object( $post ) ) {
					
					$divibars_in_post = self::$helper->searchForDiviBarsInPost( $post, 1 );
				}
				
				
				/* Search Divi divibar in active menus */
				$theme_locations = get_nav_menu_locations();
				
				$divibars_in_menus = array();
				
				$divibars['divibars_in_menus'] = array();
				
				if ( is_array( $theme_locations ) && count( $theme_locations ) > 0 ) {
					
					$divibars_in_menus = array();
					
					foreach( $theme_locations as $theme_location => $theme_location_value ) {
						
						$menu = get_term( $theme_locations[$theme_location], 'nav_menu' );
						
						// menu exists?
						if ( !is_wp_error($menu) && $menu !== null ) {
							
							$menu_term_id = $menu->term_id;
							
							// Support WPML for menus
							if ( function_exists( 'icl_object_id' ) ) {
								$menu_term_id = icl_object_id( $menu->term_id, 'nav_menu' );
							}
							
							$menu_items = wp_get_nav_menu_items( $menu_term_id );
							
							foreach ( (array) $menu_items as $it_key => $menu_item ) {
								
								$url = $menu_item->url;
								
								if ( $url ) {
									
									$extract_id = self::$helper->prepareBars( $url );
									
									if ( $extract_id ) {
										
										$divibars_in_menus[ $extract_id ] = 1;
									}
								}
								
								/* Search Divi divibar in menu classes */
								if ( isset( $menu_item->classes[0] ) && $menu_item->classes[0] != '' && count( $menu_item->classes ) > 0 ) {
									
									foreach ( $menu_item->classes as $cl_key => $class ) {
										
										if ( $class != '' ) {
											
											$extract_id = self::$helper->prepareBars( $class );
											
											if ( $extract_id ) {
											
												$divibars_in_menus[ $extract_id ] = 1;
											}
										}
									}
								}
								
								/* Search Divi divibar in Link Relationship (XFN) */
								if ( !empty( $menu_item->xfn ) ) {
									
									$extract_id = self::$helper->prepareBars( $menu_item->xfn );
									
									if ( $extract_id ) {
									
										$divibars_in_menus[ $extract_id ] = 1;
									}
								}
							}
						}
						else {
							
							
						}
					}
				}
				$divibars_in_menus = array_filter( $divibars_in_menus );
				$divibars['divibars_in_menus'] = $divibars_in_menus;
				
				
				/* Search CSS Triggers in all Divi divibars */
				$divibars_with_css_trigger = array();
				
				$divibars['divibars_with_css_trigger'] = array();
				
				$dwct_posts = DiviBars_Model::getDivibars('css_trigger');
				
				if ( isset( $dwct_posts[0] ) ) {
					
					foreach( $dwct_posts as $dv_post ) {
						
						$post_id = $dv_post->ID;
						
						$get_css_selector = get_post_meta( $post_id, 'dib_css_selector' );
							
						$css_selector = $get_css_selector[0];
						
						if ( $css_selector != '' ) {
						
							$divibars_with_css_trigger[ $post_id ] = $css_selector;
						}
					}
					
					$divibars['divibars_with_css_trigger'] = $divibars_with_css_trigger;
				}
				
				
				/* Search URL Triggers in all Divibars */
				$divibars_with_url_trigger = array();
				
				$divibars['divibars_with_url_trigger'] = array();
				
				$dwut_posts = DiviBars_Model::getDivibars('enableurltrigger');
				
				if ( isset( $dwut_posts[0] ) ) {
					
					foreach( $dwut_posts as $dv_post ) {
						
						$post_id = $dv_post->ID;
						
						$divibars_with_url_trigger[ $post_id ] = 1;
					}
				}
				$divibars_with_url_trigger = array_filter( $divibars_with_url_trigger );
				$divibars['divibars_with_url_trigger'] = $divibars_with_url_trigger;
				
				
				/* Add DiviBars with Display Locations: Force render */
				$args = array(
					'meta_key'   => 'divibars_displaylocations_forcerender',
					'meta_value' => '1',
					'meta_compare' => '=',
					'post_type' => 'divi_bars',
					'cache_results'  => false
				);
				$posts = get_posts( $args );
				
				$divibars_forcerender = array();
				
				if ( isset( $posts[0] ) ) {
					
					$display_in_current = false;
					
					foreach( $posts as $dv_post ) {
						
						$post_id = $dv_post->ID;
						
						$divibars_forcerender[ $post_id ] = 1;
					}
				}
				$divibars_forcerender = array_filter( $divibars_forcerender );
				$divibars['divibars_forcerender'] = $divibars_forcerender;
				
				
				/* Search Automatic Triggers in all Divi divibars */
				
				// Server-Side Device Detection with Browscap
				require_once( plugin_dir_path( __FILE__ ) . 'includes/php-libraries/Browscap/Browscap.php' );
				$browscap = new Browscap( plugin_dir_path( __FILE__ ) . '/includes/php-libraries/Browscap/Cache/' );
				$browscap->doAutoUpdate = false;
				$current_browser = $browscap->getBrowser();
				
				self::$isMobileDevice = $current_browser->isMobileDevice;
				
				self::$isTabletDevice = $current_browser->isTablet;
				
				$divibars_with_automatic_trigger = array();
				
				$divibars['divibars_with_automatic_trigger'] = array();
				
				$dwat_posts = DiviBars_Model::getDivibars('automatic_trigger');
				
				if ( isset( $dwat_posts[0] ) ) {
					
					foreach( $dwat_posts as $dv_post ) {
						
						$post_id = $dv_post->ID;
					
						$at_disablemobile = get_post_meta( $post_id, 'divibars_automatictrigger_disablemobile' );
						$at_disabletablet = get_post_meta( $post_id, 'divibars_automatictrigger_disabletablet' );
						$at_disabledesktop = get_post_meta( $post_id, 'divibars_automatictrigger_disabledesktop' );
						$onceperload = get_post_meta( $post_id, 'divibars_automatictrigger_onceperload', true );
						
						if ( isset( $onceperload[0] ) ) {
							
							$onceperload = $onceperload[0];
							
						} else {
							
							$onceperload = 1;
						}
						
						if ( isset( $at_disablemobile[0] ) ) {
							
							$at_disablemobile = $at_disablemobile[0];
							
						} else {
							
							$at_disablemobile = 0;
						}
						
						if ( isset( $at_disabletablet[0] ) ) {
							
							$at_disabletablet = $at_disabletablet[0];
							
						} else {
							
							$at_disabletablet = 0;
						}
						
						if ( isset( $at_disabledesktop[0] ) ) {
							
							$at_disabledesktop = $at_disabledesktop[0];
							
						} else {
							
							$at_disabledesktop = 0;
						}
						
						$printSettings = 1;
						if ( $at_disablemobile && self::$isMobileDevice ) {
							
							$printSettings = 0;
						}
						
						if ( $at_disabletablet && self::$isTabletDevice ) {
							
							$printSettings = 0;
						}
						
						if ( $at_disabledesktop && !self::$isMobileDevice && !self::$isTabletDevice ) {
							
							$printSettings = 0;
						}
						
						if ( $printSettings ) {
							
							$at_type = get_post_meta( $post_id, 'divibars_automatictrigger', true );
							$at_timed = get_post_meta( $post_id, 'divibars_automatictrigger_timed_value', true );
							$at_scroll_from = get_post_meta( $post_id, 'divibars_automatictrigger_scroll_from_value', true );
							$at_scroll_to = get_post_meta( $post_id, 'divibars_automatictrigger_scroll_to_value', true );
							
							if ( $at_type != '' ) {
								
								switch ( $at_type ) {
									
									case 'divibar-timed':
										$at_value = $at_timed;
									break;
									
									case 'divibar-scroll':
										$at_value = $at_scroll_from . ':' . $at_scroll_to;
									break;
									
									default:
										$at_value = $at_type;
								}
								
								$at_settings = wp_json_encode( array( 'at_type' => $at_type, 'at_value' => $at_value, 'at_onceperload' => $onceperload ) );
								
								$divibars_with_automatic_trigger[ $post_id ] = $at_settings;
							}
						}
					}
				}
				
				$divibars_with_automatic_trigger = array_filter( $divibars_with_automatic_trigger );
				$divibars['divibars_with_automatic_trigger'] = $divibars_with_automatic_trigger;
				
				$divibars['ids'] = $divibars_in_post + $divibars_in_menus + $divibars_with_css_trigger + $divibars_with_url_trigger + $divibars_with_automatic_trigger + $divibars_forcerender;
				
				if ( is_array( $divibars['ids'] ) && count( $divibars['ids'] ) > 0 ) {
					
					add_filter( 'body_class', function ( $classes )
					{
						$classes[] = 'divibar-active';
						return $classes;
						
					}, 20, 2 );
				}
			
			} catch (Exception $e) {
			
				self::log( $e );
			}
			
			self::$divibarsList = $divibars;
		}
		
		
		protected static function load_resources() {
			
			require_once( DIVI_BARS_PLUGIN_DIR . '/includes/class.divi-bars.controller.php' );
			require_once( DIVI_BARS_PLUGIN_DIR . '/includes/class.divi-bars.model.php' );
			require_once( DIVI_BARS_PLUGIN_DIR . '/includes/class.divi-bars.helper.php' );
			require_once( DIVI_BARS_PLUGIN_DIR . '/includes/class.divi-bars.ajax.php' );
		}
		
		
		public static function register_cpt() {
			
			$labels = array(
				'name' => _x( 'Divi Bars', 'divi_bars' ),
				'singular_name' => _x( 'Divi Bars', 'divi_bars' ),
				'add_new' => _x( 'Add New', 'divi_bars' ),
				'add_new_item' => _x( 'Add New Divi Bar', 'divi_bars' ),
				'edit_item' => _x( 'Edit Divi Bar', 'divi_bars' ),
				'new_item' => _x( 'New Divi Bar', 'divi_bars' ),
				'view_item' => _x( 'View Divi Bar', 'divi_bars' ),
				'search_items' => _x( 'Search Divi Bars', 'divi_bars' ),
				'not_found' => _x( 'No Divi Bars found', 'divi_bars' ),
				'not_found_in_trash' => _x( 'No Divi Bars found in Trash', 'divi_bars' ),
				'parent_item_colon' => _x( 'Parent Divi Bar:', 'divi_bars' ),
				'menu_name' => _x( 'Divi Bars', 'divi_bars' ),
			);
			
			$args = array(
				'labels' => $labels,
				'hierarchical' => true,
				'supports' => array( 'title', 'editor', 'author', 'revisions' ),
				'public' => true,
				'show_ui' => true,
				'show_in_menu' => true,
				'menu_position' => 5,
				'show_in_nav_menus' => true,
				'exclude_from_search' => true,
				'has_archive' => true,
				'query_var' => true,
				'can_export' => true,
				'rewrite' => true,
				'capability_type' => 'post'
			);
			
			register_post_type( 'divi_bars', $args );
		}
		
		
		public static function enable_divicpt_option() {
			
			if ( function_exists( 'et_get_option' ) ) {
				
				$divi_post_types = et_get_option( 'et_pb_post_type_integration', array() );
				
				if ( !isset( $divi_post_types['divi_bars'] )
					|| ( isset( $divi_post_types['divi_bars'] ) && $divi_post_types['divi_bars'] == 'off' ) ) {
					
					$divi_post_types['divi_bars'] = 'on';
					
					et_update_option( 'et_pb_post_type_integration', $divi_post_types, false, '', '' );
				}
			}
		}
		
		
		public static function register_widget() {
			
			register_sidebar( array(
				'name' => __( 'Divi Bars - Global', 'theme-slug' ),
				'id' => 'divi-bars_global_widget',
				'description' => __( '', 'theme-slug' )
			) );
		}
		
		
		// Register all needed stylesheets
		public static function add_styles() {
			
			
			wp_register_style('DiviBars-main', DIVI_BARS_PLUGIN_URL . 'assets/css/main.css' );
			wp_enqueue_style('DiviBars-main');
		}
		
		
		// Register all needed scripts
		public static function add_scripts() {
		
			wp_register_script('DiviBars-main', DIVI_BARS_PLUGIN_URL . 'assets/js/main.js', array('jquery'), DIVI_BARS_VERSION, TRUE);
			wp_enqueue_script('DiviBars-main');
			
			wp_register_script('DiviBars-main-helper', DIVI_BARS_PLUGIN_URL . 'assets/js/main.helper.js', array('jquery', 'DiviBars-main'), DIVI_BARS_VERSION, TRUE );
			wp_enqueue_script('DiviBars-main-helper');
			
			wp_register_script('actual', plugins_url('assets/js/actual.min.js', __FILE__),array("jquery"));
			wp_enqueue_script('actual');
		}
		
		
		public static function add_var_ajaxurl() {
		?>
		<script type="text/javascript">
		var ajax_url = '<?php print esc_url( admin_url('admin-ajax.php') ); ?>';
		</script>
		<?php
		}
		
		
		private static function is_divi_builder_enabled() {
			
			// phpcs:ignore WordPress.Security.NonceVerification.Recommended
			if ( isset( $_GET['et_fb'] ) ) {
				
				// phpcs:ignore WordPress.Security.NonceVerification.Recommended
				$divi_builder_enabled = sanitize_text_field( wp_unslash( $_GET['et_fb'] ) );
				
				// is divi theme builder ?
				if ( $divi_builder_enabled === '1' ) {
					
					return TRUE;
				}
			}
			
			return FALSE;
		}
		
		/**
		 * Log debugging infoormation to the error log.
		 *
		 * @param string $e The Exception object
		 */
		public static function log( $e = FALSE ) {
			
			$data_log = $e;
			
			if ( is_object( $e ) ) {
				
				$data_log = sprintf( "Exception: \n %s \n", $e->getMessage() . "\r\n\r\n" . $e->getFile() . "\r\n" . 'Line:' . $e->getLine() );
			}
			
			if ( apply_filters( 'divibars_log', defined( 'WP_DEBUG' ) && WP_DEBUG && defined( 'WP_DEBUG_LOG' ) && WP_DEBUG_LOG ) ) {
				
				// phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_print_r
				$log = print_r( compact( 'data_log' ), true );
				
				// phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_error_log
				error_log( $log );
			}
		}
	}