<?php

namespace WP_Business_Reviews_Bundle\Includes;

use WP_Business_Reviews_Bundle\Includes\Core\Database;

class Plugin_Overview {

    private $helper;

    public function __construct(Helper $helper) {
        $this->helper = $helper;
    }

    public function register() {
        add_action('brb_admin_page_brb', array($this, 'init'));
        add_action('brb_admin_page_brb', array($this, 'render'));
    }

    public function init() {

    }

    public function render() {
        global $wpdb;

        $connects = $wpdb->get_results(
            'SELECT conn_id, conn_name, platform FROM ' . $wpdb->prefix . Database::CONNECT_TABLE .
            ' WHERE platform = "google" GROUP BY conn_id ORDER BY MAX(coll_id) DESC;'
        );

        if (count($connects) > 0) {
            $url = 'https://app.richplugins.com/stats/get/json?id=' . $connects[0]->conn_id . '&auth_code=' . get_option('brb_auth_code');
            $stats = $this->helper->json_remote_get($url);
        }

        wp_nonce_field('brb_wpnonce', 'brb_nonce');
        //wp_enqueue_script('brb-admin-apexcharts-js');
        ?>

        <link rel="stylesheet" href="https://www.w3schools.com/w3css/4/w3.css">

        <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.30.1/moment.min.js"></script>

        <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/4.4.1/chart.umd.js"></script>

        <script src="https://cdnjs.cloudflare.com/ajax/libs/chartjs-adapter-moment/1.0.1/chartjs-adapter-moment.min.js"></script>

        <script src="https://cdnjs.cloudflare.com/ajax/libs/chartjs-plugin-datalabels/2.2.0/chartjs-plugin-datalabels.min.js"></script>



        <!--div class="brb-page-title">
            Overview
        </div-->

        <div class="grw-overview-workspace metabox-holder">

            <textarea id="stats" style="display:none"><?php echo json_encode($stats); ?></textarea>

            <div class="w3-row">

                <div class="w3-col m9 s12">

                    <div class="w3-row-padding">

                        <div class="w3-col s12">
                            <!-- Stats -->
                            <div class="postbox">
                                <div class="postbox-header">
                                    <h2 class="hndle">Stats</h2>
                                    <div class="handle-actions hide-if-no-js">
                                        <select id="grw-overview-months" style="border:none">
                                            <option value="6" selected>6 last months</option>
                                            <option value="12">12 last months</option>
                                            <option value="24">2 last years</option>
                                            <option value="36">3 last years</option>
                                            <option value="60">5 last years</option>
                                        </select>
                                        <select id="grw-overview-places" style="border:none"><?php
                                        foreach ($connects as $conn) {
                                            ?><option value="<?php echo $conn->conn_id; ?>" data-platform="<?php echo $conn->platform; ?>">
                                                <?php echo $conn->conn_name; ?>
                                            </option><?php
                                        }
                                        ?></select>
                                    </div>
                                </div>
                                <div class="inside">
                                    <div class="main">
                                        <div id="legend-container"></div>
                                        <div class="col-md-12 mt-2">
                                            <canvas id="review_chart" style="height: 275px; display: block; box-sizing: border-box; width: 1190px;" width="2976" height="687">Your browser does not support the canvas element.</canvas>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="w3-col s6">
                            <!-- Rating -->
                            <div class="postbox">
                                <div class="postbox-header">
                                    <h2 class="hndle ui-sortable-handle">Rating</h2>
                                    <div class="handle-actions hide-if-no-js">
                                        <!-- TODO -->
                                    </div>
                                </div>
                                <div class="inside">
                                    <div class="main">
                                        <div id="grw-overview-rating"><img src="<?php echo BRB_ASSETS_URL; ?>img/dots-spinner.svg"></div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="w3-col s6">
                            <!-- Usage -->
                            <div class="postbox">
                                <div class="postbox-header">
                                    <h2 class="hndle ui-sortable-handle">While using the plugin</h2>
                                    <div class="handle-actions hide-if-no-js">
                                        <!-- TODO -->
                                    </div>
                                </div>
                                <div class="inside">
                                    <div class="main">
                                        <div id="grw-overview-stats"><img src="<?php echo BRB_ASSETS_URL; ?>img/dots-spinner.svg"></div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>

                </div>

                <div class="w3-col m3 s12">

                    <!-- Recent reviews -->
                    <div class="postbox" style="">
                        <div class="postbox-header">
                            <h2 class="hndle ui-sortable-handle">Latest Reviews</h2>
                            <div class="handle-actions hide-if-no-js">
                                <!-- TODO -->
                            </div>
                        </div>
                        <div class="inside">
                            <div class="main">
                                <div id="grw-overview-reviews">
                                    <div class="rpi" style="--img-size:24px;--star-size:14px;--info-gap:2px;--card-gap:8px;--card-padding:4px;--card-bg:#f5f5f5;">
                                        <div class="rpi-list">
                                            <div class="rpi-content">
                                                <div class="rpi-cards"><img src="<?php echo BRB_ASSETS_URL; ?>img/dots-spinner.svg"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

        </div>

        <?php
    }
}
