<?php

namespace WP_Business_Reviews_Bundle\Includes;

class Plugin_Overview_Ajax {

   private $helper;

    public function __construct(Helper $helper) {
        $this->helper = $helper;

        add_action('wp_ajax_brb_stats', array($this, 'stats'));
        add_action('wp_ajax_brb_reply', array($this, 'reply'));
    }

    public function stats() {
        $url = 'https://app.richplugins.com/stats/get/json?id=' . sanitize_text_field(wp_unslash($_POST['conn_id'])) .
               '&auth_code=' . get_option('brb_auth_code');

        $stats = $this->helper->json_remote_get($url);
        echo json_encode($stats);
        die();
    }

    public function reply() {
        $url = 'https://app.richplugins.com/stats/reply?id=' . sanitize_text_field(wp_unslash($_POST['conn_id'])) .
               '/reviews/' . sanitize_text_field(wp_unslash($_POST['rev_id'])) .
               '&auth_code=' . get_option('brb_auth_code');

        $reply = $this->helper->json_remote_post($url, array('comment' => sanitize_text_field(wp_unslash($_POST['comment']))));
        echo json_encode($reply);
        die();
    }
}
