<?php

/*
 * Plugin Name: Divi Ultimate Blog Plugin
 * Plugin URI:  https://blog.diviultimate.com
 * Description: Divi plugin that solves the styling for Divi blog post.
 * Author:      Divi Ultimate
 * Version:     1.1.0
 * Author URI:  https://diviultimate.com
 */

if ( ! defined( 'ABSPATH' ) ) exit; 
define('DIVI_ULTIMATE_BLOG_PLUGIN_VERSION', '1.1.0.11');

add_action('plugins_loaded', 'divi_ultimate_blog_plugin_init');

function divi_ultimate_blog_plugin_init() {
	add_action( 'wp_enqueue_scripts', 'divi_ultimate_blog_plugin_main_css', 20 ); 
	add_filter( 'body_class', 'divi_ultimate_blog_plugin_add_body_class' );
	add_action( 'wp_head', 'divi_ultimate_blog_plugin_css_edit' );
	add_action( 'customize_register', 'divi_ultimate_blog_plugin_customizer_settings', 999 );
	add_action( 'customize_controls_enqueue_scripts', 'divi_ultimate_blog_plugin_customize_controls_js_css' );
	add_action( 'customize_preview_init', 'divi_ultimate_blog_plugin_customize_preview_js' );
	add_filter( 'template_include', 'divi_ultimate_blog_plugin_blog_post' );
}

// ------------- DU Blog Post Function Start -----------------
function divi_ultimate_blog_plugin_blog_post($template) {
	$divi_ultimate_blog_plugin_blog_post_enable = get_option( 'divi_ultimate_blog_plugin_blog_post_enable' );
	if ( $divi_ultimate_blog_plugin_blog_post_enable ) {
		if( ('single.php' == basename($template)) && (stripos($template,'/wp-content/themes/') !== false) ) {
			$template = plugin_dir_path( __FILE__ ) . 'blog/du-blog-1.php';
		}
	}

    return $template;
}
// ------------- DU Blog Post Function End -----------------

// -------------- Load main CSS and JS Start ----------------
function divi_ultimate_blog_plugin_main_css() { 
	$divi_ultimate_blog_plugin_blog_post_enable = get_option( 'divi_ultimate_blog_plugin_blog_post_enable' );
	
	if ($divi_ultimate_blog_plugin_blog_post_enable) {
		wp_enqueue_style('divi-ultimate-blog-plugin-main-css', plugin_dir_url( __FILE__ ) . 'css/main.css', array(), DIVI_ULTIMATE_BLOG_PLUGIN_VERSION);
	}
} 
// -------------- Load main CSS and JS End ----------------

// -------------- Customizer Settings Start ----------------
function divi_ultimate_blog_plugin_customizer_settings($wp_customize) {
    
	// Add new panel
	$wp_customize->add_panel( 'divi_ultimate_blog_plugin_blog_post_customizer_options', array(
		'priority'       => 0,
		'capability'     => 'edit_theme_options',
		'title'          => 'Divi Ultimate Blog Post',
		'description'    => 'Custom styling for your blog post.',
	));

	// Add new sections
	$wp_customize->add_section('divi_ultimate_blog_plugin_blog_post_main_settings', array(
		'priority' => 5,
		'title' => 'Blog Main Settings',
		'panel'  => 'divi_ultimate_blog_plugin_blog_post_customizer_options',
	)); 
	
	$wp_customize->add_section('divi_ultimate_blog_plugin_blog_post_header', array(
		'priority' => 10,
		'title' => 'Customize Blog Header',
		'panel'  => 'divi_ultimate_blog_plugin_blog_post_customizer_options',
	));
	
	$wp_customize->add_section('divi_ultimate_blog_plugin_blog_post_featured_image', array(
		'priority' => 20,
		'title' => 'Customize Blog Featured Image',
		'panel'  => 'divi_ultimate_blog_plugin_blog_post_customizer_options',
	));
	
	$wp_customize->add_section('divi_ultimate_blog_plugin_blog_post_sidebar', array(
		'priority' => 30,
		'title' => 'Customize Blog Sidebar',
		'panel'  => 'divi_ultimate_blog_plugin_blog_post_customizer_options',
	));
	
	$wp_customize->add_section('divi_ultimate_blog_plugin_blog_post_navigation', array(
		'priority' => 40,
		'title' => 'Customize Blog Post Navigation',
		'panel'  => 'divi_ultimate_blog_plugin_blog_post_customizer_options',
	));
	
	$wp_customize->add_section('divi_ultimate_blog_plugin_blog_post_related_posts', array(
		'priority' => 50,
		'title' => 'Customize Blog Related Posts',
		'panel'  => 'divi_ultimate_blog_plugin_blog_post_customizer_options',
	));

	$wp_customize->add_section('divi_ultimate_blog_plugin_blog_post_comments', array(
		'priority' => 60,
		'title' => 'Customize Blog Comments',
		'panel'  => 'divi_ultimate_blog_plugin_blog_post_customizer_options',
	));


	// Add new settings
	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_enable', array(
		'default'        => false,
		'type'           => 'option',
		'capability'     => 'edit_theme_options',
	));

	$wp_customize->add_control( 'divi_ultimate_blog_plugin_blog_post_enable', array(
		'settings' => 'divi_ultimate_blog_plugin_blog_post_enable',
		'label'    => 'Enable Divi Ultimate Blog Design',
		'section'  => 'divi_ultimate_blog_plugin_blog_post_main_settings',
		'type'     => 'checkbox',
	));
	
	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_header_style', array(
		'default'        => 'none',
		'type'           => 'option',
		'capability'     => 'edit_theme_options',
		'transport'     => 'postMessage',
	));

	$wp_customize->add_control( 'divi_ultimate_blog_plugin_blog_post_header_style', array(
		'settings' => 'divi_ultimate_blog_plugin_blog_post_header_style',
		'label'    => 'Choose your blog header style',
		'section'  => 'divi_ultimate_blog_plugin_blog_post_main_settings',
		'type'     => 'select',
		'choices'  => array(
			'none' => 'Style 1',
			'free-blog-post-style-2' => 'Style 2',
			'free-blog-post-style-3' => 'Style 3',
			'free-blog-post-style-4' => 'Style 4',
			'free-blog-post-style-5' => 'Style 5',
		),
	));
	
	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_header_parallax', array(
		'default'        => 'none',
		'type'           => 'option',
		'capability'     => 'edit_theme_options',
	));

	$wp_customize->add_control( 'divi_ultimate_blog_plugin_blog_post_header_parallax', array(
		'settings' => 'divi_ultimate_blog_plugin_blog_post_header_parallax',
		'label'    => 'Parallax for Blog Header Featured',
		'section'  => 'divi_ultimate_blog_plugin_blog_post_main_settings',
		'type'     => 'select',
		'choices'  => array(
			'none' => 'None',
			'parallax' => 'True Parallax',
			'css' => 'CSS Fixed',
		),
	));
	
	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_navigation_style', array(
		'default'        => 'free-blog-post-navigation-hide',
		'type'           => 'option',
		'capability'     => 'edit_theme_options',
		'transport'     => 'postMessage',
	));

	$wp_customize->add_control( 'divi_ultimate_blog_plugin_blog_post_navigation_style', array(
		'settings' => 'divi_ultimate_blog_plugin_blog_post_navigation_style',
		'label'    => 'Choose your post navigation style',
		'section'  => 'divi_ultimate_blog_plugin_blog_post_main_settings',
		'type'     => 'select',
		'choices'  => array(
			'free-blog-post-navigation-hide' => 'None',
			'free-blog-post-navigation-style-1' => 'Style 1',
		),
	));	

	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_related_posts_style', array(
		'default'        => 'free-blog-post-related-posts-hide',
		'type'           => 'option',
		'capability'     => 'edit_theme_options',
		'transport'     => 'postMessage',
	));

	$wp_customize->add_control( 'divi_ultimate_blog_plugin_blog_post_related_posts_style', array(
		'settings' => 'divi_ultimate_blog_plugin_blog_post_related_posts_style',
		'label'    => 'Choose your related posts style',
		'section'  => 'divi_ultimate_blog_plugin_blog_post_main_settings',
		'type'     => 'select',
		'choices'  => array(
			'free-blog-post-related-posts-hide' => 'None',
			' ' => 'Style 1',
			'free-blog-list-2' => 'Style 2',
			'free-blog-list-2 free-blog-background-solid free-blog-all-center' => 'Style 3',
		),
	));	
	
	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_related_posts_border_radius', array(
		'default'       => '15',
		'type'          => 'option',
		'capability'    => 'edit_theme_options',
		'transport'     => 'postMessage',
		'sanitize_callback' => 'absint',
	) );

	$wp_customize->add_control( new ET_Divi_Range_Option ( $wp_customize, 'divi_ultimate_blog_plugin_blog_post_related_posts_border_radius', array(
		'label'	      => 'Related Posts Border Radius',
		'section'     => 'divi_ultimate_blog_plugin_blog_post_main_settings',
		'settings'	  => 'divi_ultimate_blog_plugin_blog_post_related_posts_border_radius',
		'type'        => 'range',
		'input_attrs' => array(
			'min'  => 0,
			'max'  => 100,
			'step' => 1
		),
	) ) );
	
    $wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_footer', array(
        'default'        => 'none',
        'type'           => 'option',
        'capability'     => 'edit_theme_options' 
    ));

    $wp_customize->add_control( 'divi_ultimate_blog_plugin_blog_post_footer', array(
        'settings' => 'divi_ultimate_blog_plugin_blog_post_footer',
        'label'    => 'Inject Divi Library item as blog footer',
        'section'  => 'divi_ultimate_blog_plugin_blog_post_main_settings',
		'type'     => 'select',
		'choices'  => divi_ultimate_blog_plugin_blog_post_footer_choices(),
    ));
	
	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_header_custom', array(
		'default'        => false,
		'type'           => 'option',
		'capability'     => 'edit_theme_options',
		'transport'     => 'postMessage',
	));

	$wp_customize->add_control( 'divi_ultimate_blog_plugin_blog_post_header_custom', array(
		'settings' => 'divi_ultimate_blog_plugin_blog_post_header_custom',
		'label'    => 'Custom Blog Header Settings',
		'section'  => 'divi_ultimate_blog_plugin_blog_post_header',
		'type'     => 'checkbox',
	));
	
	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_header_custom_hide', array(
		'default'        => false,
		'type'           => 'option',
		'capability'     => 'edit_theme_options',
		'transport'     => 'postMessage',
	));

	$wp_customize->add_control( 'divi_ultimate_blog_plugin_blog_post_header_custom_hide', array(
		'settings' => 'divi_ultimate_blog_plugin_blog_post_header_custom_hide',
		'label'    => 'Hide featured header image',
		'section'  => 'divi_ultimate_blog_plugin_blog_post_header',
		'type'     => 'checkbox',
	));
	
	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_header_custom_overlay', array(
		'default'        => 'free-blog-post-header-featured-overlay-none',
		'type'           => 'option',
		'capability'     => 'edit_theme_options',
		'transport'     => 'postMessage',
	));

	$wp_customize->add_control( 'divi_ultimate_blog_plugin_blog_post_header_custom_overlay', array(
		'settings' => 'divi_ultimate_blog_plugin_blog_post_header_custom_overlay',
		'label'    => 'Choose your featured header overlay',
		'section'  => 'divi_ultimate_blog_plugin_blog_post_header',
		'type'     => 'select',
		'choices'  => array(
			'free-blog-post-header-featured-overlay-none' => 'None',
			'free-blog-post-header-featured-overlay-solid' => 'Solid',
			'free-blog-post-header-featured-overlay-gradient' => 'Gradient',
		),
	));	
	
	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_header_custom_blur', array(
		'default'       => '0',
		'type'          => 'option',
		'capability'    => 'edit_theme_options',
		'transport'     => 'postMessage',
		'sanitize_callback' => 'absint',
	) );

	$wp_customize->add_control( new ET_Divi_Range_Option ( $wp_customize, 'divi_ultimate_blog_plugin_blog_post_header_custom_blur', array(
		'label'	      => 'Featured Header Blur',
		'section'     => 'divi_ultimate_blog_plugin_blog_post_header',
		'settings'	  => 'divi_ultimate_blog_plugin_blog_post_header_custom_blur',
		'type'        => 'range',
		'input_attrs' => array(
			'min'  => 0,
			'max'  => 100,
			'step' => 1
		),
	) ) );
	
	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_header_custom_scale', array(
		'default'       => '0',
		'type'          => 'option',
		'capability'    => 'edit_theme_options',
		'transport'     => 'postMessage',
		'sanitize_callback' => 'absint',
	) );

	$wp_customize->add_control( new ET_Divi_Range_Option ( $wp_customize, 'divi_ultimate_blog_plugin_blog_post_header_custom_scale', array(
		'label'	      => 'Featured Header Scale',
		'section'     => 'divi_ultimate_blog_plugin_blog_post_header',
		'settings'	  => 'divi_ultimate_blog_plugin_blog_post_header_custom_scale',
		'type'        => 'range',
		'input_attrs' => array(
			'min'  => 0,
			'max'  => 9,
			'step' => 1
		),
	) ) );

	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_header_custom_padding_top', array(
		'default'       => '42',
		'type'          => 'option',
		'capability'    => 'edit_theme_options',
		'transport'     => 'postMessage',
		'sanitize_callback' => 'absint',
	) );

	$wp_customize->add_control( new ET_Divi_Range_Option ( $wp_customize, 'divi_ultimate_blog_plugin_blog_post_header_custom_padding_top', array(
		'label'	      => 'Header Content Padding Top',
		'section'     => 'divi_ultimate_blog_plugin_blog_post_header',
		'settings'	  => 'divi_ultimate_blog_plugin_blog_post_header_custom_padding_top',
		'type'        => 'range',
		'input_attrs' => array(
			'min'  => 0,
			'max'  => 500,
			'step' => 1
		),
	) ) );
	
	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_header_custom_padding_bottom', array(
		'default'       => '100',
		'type'          => 'option',
		'capability'    => 'edit_theme_options',
		'transport'     => 'postMessage',
		'sanitize_callback' => 'absint',
	) );

	$wp_customize->add_control( new ET_Divi_Range_Option ( $wp_customize, 'divi_ultimate_blog_plugin_blog_post_header_custom_padding_bottom', array(
		'label'	      => 'Header Content Padding Bottom',
		'section'     => 'divi_ultimate_blog_plugin_blog_post_header',
		'settings'	  => 'divi_ultimate_blog_plugin_blog_post_header_custom_padding_bottom',
		'type'        => 'range',
		'input_attrs' => array(
			'min'  => 0,
			'max'  => 500,
			'step' => 1
		),
	) ) );
	
	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_header_custom_alignment', array(
		'default'        => 'free-blog-post-header-content-center',
		'type'           => 'option',
		'capability'     => 'edit_theme_options',
		'transport'     => 'postMessage',
	));

	$wp_customize->add_control( 'divi_ultimate_blog_plugin_blog_post_header_custom_alignment', array(
		'settings' => 'divi_ultimate_blog_plugin_blog_post_header_custom_alignment',
		'label'    => 'Choose your header content alignment',
		'section'  => 'divi_ultimate_blog_plugin_blog_post_header',
		'type'     => 'select',
		'choices'  => array(
			'free-blog-post-header-content-center' => 'Center',
			'free-blog-post-header-content-left' => 'Left',
			'free-blog-post-header-content-right' => 'Right',
		),
	));	
	
	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_header_custom_width', array(
		'default'       => '700',
		'type'          => 'option',
		'capability'    => 'edit_theme_options',
		'transport'     => 'postMessage',
		'sanitize_callback' => 'absint',
	) );

	$wp_customize->add_control( new ET_Divi_Range_Option ( $wp_customize, 'divi_ultimate_blog_plugin_blog_post_header_custom_width', array(
		'label'	      => 'Header Content Max Width',
		'section'     => 'divi_ultimate_blog_plugin_blog_post_header',
		'settings'	  => 'divi_ultimate_blog_plugin_blog_post_header_custom_width',
		'type'        => 'range',
		'input_attrs' => array(
			'min'  => 300,
			'max'  => 1140,
			'step' => 1
		),
	) ) );
	
	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_header_custom_title_uppercase', array(
		'default'        => false,
		'type'           => 'option',
		'capability'     => 'edit_theme_options',
		'transport'     => 'postMessage',
	));

	$wp_customize->add_control( 'divi_ultimate_blog_plugin_blog_post_header_custom_title_uppercase', array(
		'settings' => 'divi_ultimate_blog_plugin_blog_post_header_custom_title_uppercase',
		'label'    => 'Header Title Uppercase',
		'section'  => 'divi_ultimate_blog_plugin_blog_post_header',
		'type'     => 'checkbox',
	));	
	
	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_header_custom_meta_uppercase', array(
		'default'        => false,
		'type'           => 'option',
		'capability'     => 'edit_theme_options',
		'transport'     => 'postMessage',
	));

	$wp_customize->add_control( 'divi_ultimate_blog_plugin_blog_post_header_custom_meta_uppercase', array(
		'settings' => 'divi_ultimate_blog_plugin_blog_post_header_custom_meta_uppercase',
		'label'    => 'Header Meta Uppercase',
		'section'  => 'divi_ultimate_blog_plugin_blog_post_header',
		'type'     => 'checkbox',
	));
	
	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_header_custom_title_size', array(
		'default'       => '38',
		'type'          => 'option',
		'capability'    => 'edit_theme_options',
		'transport'     => 'postMessage',
		'sanitize_callback' => 'absint',
	) );

	$wp_customize->add_control( new ET_Divi_Range_Option ( $wp_customize, 'divi_ultimate_blog_plugin_blog_post_header_custom_title_size', array(
		'label'	      => 'Header Title Font Size',
		'section'     => 'divi_ultimate_blog_plugin_blog_post_header',
		'settings'	  => 'divi_ultimate_blog_plugin_blog_post_header_custom_title_size',
		'type'        => 'range',
		'input_attrs' => array(
			'min'  => 14,
			'max'  => 100,
			'step' => 1
		),
	) ) );
	
	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_header_custom_title_weight', array(
		'default'        => '700',
		'type'           => 'option',
		'capability'     => 'edit_theme_options',
		'transport'     => 'postMessage',
	));

	$wp_customize->add_control( 'divi_ultimate_blog_plugin_blog_post_header_custom_title_weight', array(
		'settings' => 'divi_ultimate_blog_plugin_blog_post_header_custom_title_weight',
		'label'    => 'Header Title Font Weight',
		'section'  => 'divi_ultimate_blog_plugin_blog_post_header',
		'type'     => 'select',
		'choices'  => array(
			'100' => 'Thin',
			'200' => 'Extra Light',
			'300' => 'Light',
			'400' => 'Regular',
			'600' => 'Semi Bold',
			'700' => 'Bold',
			'800' => 'Ultra Bold',
		),
	));	
	
	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_header_custom_background_color', array(
		'default'		=> null,
		'type'			=> 'option',
		'capability'	=> 'edit_theme_options',
		'transport'     => 'postMessage',
	) );
	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'divi_ultimate_blog_plugin_blog_post_header_custom_background_color', array(
		'label'		=> 'Blog Header Background Color',
		'section'	=> 'divi_ultimate_blog_plugin_blog_post_header',
		'settings'	=> 'divi_ultimate_blog_plugin_blog_post_header_custom_background_color',
	) ) );
	
	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_header_custom_title_color', array(
		'default'		=> null,
		'type'			=> 'option',
		'capability'	=> 'edit_theme_options',
		'transport'     => 'postMessage',
	) );
	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'divi_ultimate_blog_plugin_blog_post_header_custom_title_color', array(
		'label'		=> 'Blog Header Title Color',
		'section'	=> 'divi_ultimate_blog_plugin_blog_post_header',
		'settings'	=> 'divi_ultimate_blog_plugin_blog_post_header_custom_title_color',
	) ) );
	
	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_header_custom_meta_color', array(
		'default'		=> null,
		'type'			=> 'option',
		'capability'	=> 'edit_theme_options',
		'transport'     => 'postMessage',
	) );
	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'divi_ultimate_blog_plugin_blog_post_header_custom_meta_color', array(
		'label'		=> 'Blog Header Meta Color',
		'section'	=> 'divi_ultimate_blog_plugin_blog_post_header',
		'settings'	=> 'divi_ultimate_blog_plugin_blog_post_header_custom_meta_color',
	) ) );
	
	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_featured_image_custom', array(
		'default'        => false,
		'type'           => 'option',
		'capability'     => 'edit_theme_options',
		'transport'     => 'postMessage',
	));

	$wp_customize->add_control( 'divi_ultimate_blog_plugin_blog_post_featured_image_custom', array(
		'settings' => 'divi_ultimate_blog_plugin_blog_post_featured_image_custom',
		'label'    => 'Custom Featured Image Settings',
		'section'  => 'divi_ultimate_blog_plugin_blog_post_featured_image',
		'type'     => 'checkbox',
	));
	
	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_featured_image_custom_hide', array(
		'default'        => false,
		'type'           => 'option',
		'capability'     => 'edit_theme_options',
		'transport'     => 'postMessage',
	));

	$wp_customize->add_control( 'divi_ultimate_blog_plugin_blog_post_featured_image_custom_hide', array(
		'settings' => 'divi_ultimate_blog_plugin_blog_post_featured_image_custom_hide',
		'label'    => 'Hide Featured Image',
		'section'  => 'divi_ultimate_blog_plugin_blog_post_featured_image',
		'type'     => 'checkbox',
	));	
	
	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_featured_image_custom_box_shadow', array(
		'default'        => false,
		'type'           => 'option',
		'capability'     => 'edit_theme_options',
		'transport'     => 'postMessage',
	));

	$wp_customize->add_control( 'divi_ultimate_blog_plugin_blog_post_featured_image_custom_box_shadow', array(
		'settings' => 'divi_ultimate_blog_plugin_blog_post_featured_image_custom_box_shadow',
		'label'    => 'Box Shadow for Featured Image',
		'section'  => 'divi_ultimate_blog_plugin_blog_post_featured_image',
		'type'     => 'checkbox',
	));	
	
	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_featured_image_custom_offset', array(
		'default'       => '0',
		'type'          => 'option',
		'capability'    => 'edit_theme_options',
		'transport'     => 'postMessage',
		'sanitize_callback' => 'absint',
	) );

	$wp_customize->add_control( new ET_Divi_Range_Option ( $wp_customize, 'divi_ultimate_blog_plugin_blog_post_featured_image_custom_offset', array(
		'label'	      => 'Featured Image Top Offset',
		'section'     => 'divi_ultimate_blog_plugin_blog_post_featured_image',
		'settings'	  => 'divi_ultimate_blog_plugin_blog_post_featured_image_custom_offset',
		'type'        => 'range',
		'input_attrs' => array(
			'min'  => 0,
			'max'  => 300,
			'step' => 1
		),
	) ) );	
	
	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_featured_image_custom_border_width', array(
		'default'       => '0',
		'type'          => 'option',
		'capability'    => 'edit_theme_options',
		'transport'     => 'postMessage',
		'sanitize_callback' => 'absint',
	) );

	$wp_customize->add_control( new ET_Divi_Range_Option ( $wp_customize, 'divi_ultimate_blog_plugin_blog_post_featured_image_custom_border_width', array(
		'label'	      => 'Featured Image Border Width',
		'section'     => 'divi_ultimate_blog_plugin_blog_post_featured_image',
		'settings'	  => 'divi_ultimate_blog_plugin_blog_post_featured_image_custom_border_width',
		'type'        => 'range',
		'input_attrs' => array(
			'min'  => 0,
			'max'  => 30,
			'step' => 1
		),
	) ) );	
	
	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_sidebar_hide', array(
		'default'        => false,
		'type'           => 'option',
		'capability'     => 'edit_theme_options',
		'transport'     => 'postMessage',
	));

	$wp_customize->add_control( 'divi_ultimate_blog_plugin_blog_post_sidebar_hide', array(
		'settings' => 'divi_ultimate_blog_plugin_blog_post_sidebar_hide',
		'label'    => 'Hide Blog Sidebar',
		'section'  => 'divi_ultimate_blog_plugin_blog_post_sidebar',
		'type'     => 'checkbox',
	));
	
	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_sidebar_mobile_move_to_footer', array(
		'default'        => false,
		'type'           => 'option',
		'capability'     => 'edit_theme_options',
		'transport'     => 'postMessage',
	));

	$wp_customize->add_control( 'divi_ultimate_blog_plugin_blog_post_sidebar_mobile_move_to_footer', array(
		'settings' => 'divi_ultimate_blog_plugin_blog_post_sidebar_mobile_move_to_footer',
		'label'    => 'In mobile, move sidebar to footer',
		'section'  => 'divi_ultimate_blog_plugin_blog_post_sidebar',
		'type'     => 'checkbox',
	));
	
	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_navigation_previous_text', array(
		'default'		=> 'Previous',
		'type'			=> 'option',
		'capability'	=> 'edit_theme_options',
		'transport'		=> 'postMessage',
	) );

	$wp_customize->add_control( 'divi_ultimate_blog_plugin_blog_post_navigation_previous_text', array(
		'settings' => 'divi_ultimate_blog_plugin_blog_post_navigation_previous_text',
		'label'		=> '"Previous" Text',
		'section'	=> 'divi_ultimate_blog_plugin_blog_post_navigation',
		'type'      => 'text',
	) );
	
	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_navigation_next_text', array(
		'default'		=> 'Next',
		'type'			=> 'option',
		'capability'	=> 'edit_theme_options',
		'transport'		=> 'postMessage',
	) );

	$wp_customize->add_control( 'divi_ultimate_blog_plugin_blog_post_navigation_next_text', array(
		'settings' => 'divi_ultimate_blog_plugin_blog_post_navigation_next_text',
		'label'		=> '"Next" Text',
		'section'	=> 'divi_ultimate_blog_plugin_blog_post_navigation',
		'type'      => 'text',
	) );
	
	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_navigation_same_category', array(
		'default'        => false,
		'type'           => 'option',
		'capability'     => 'edit_theme_options',
		'transport'     => 'postMessage',
	));

	$wp_customize->add_control( 'divi_ultimate_blog_plugin_blog_post_navigation_same_category', array(
		'settings' => 'divi_ultimate_blog_plugin_blog_post_navigation_same_category',
		'label'    => 'Navigate to same category only',
		'section'  => 'divi_ultimate_blog_plugin_blog_post_navigation',
		'type'     => 'checkbox',
	));
	
	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_related_posts_title', array(
		'default'		=> 'Related Posts',
		'type'			=> 'option',
		'capability'	=> 'edit_theme_options',
		'transport'		=> 'postMessage',
	) );

	$wp_customize->add_control( 'divi_ultimate_blog_plugin_blog_post_related_posts_title', array(
		'settings' => 'divi_ultimate_blog_plugin_blog_post_related_posts_title',
		'label'		=> 'Related Posts Title',
		'section'	=> 'divi_ultimate_blog_plugin_blog_post_related_posts',
		'type'      => 'text',
	) );
	
	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_related_posts_background_color', array(
		'default'		=> null,
		'type'			=> 'option',
		'capability'	=> 'edit_theme_options',
		'transport'     => 'postMessage',
	) );
	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'divi_ultimate_blog_plugin_blog_post_related_posts_background_color', array(
		'label'		=> 'Related Posts Background Color',
		'section'	=> 'divi_ultimate_blog_plugin_blog_post_related_posts',
		'settings'	=> 'divi_ultimate_blog_plugin_blog_post_related_posts_background_color',
	) ) );
	
	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_related_posts_title_color', array(
		'default'		=> null,
		'type'			=> 'option',
		'capability'	=> 'edit_theme_options',
		'transport'     => 'postMessage',
	) );
	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'divi_ultimate_blog_plugin_blog_post_related_posts_title_color', array(
		'label'		=> 'Related Posts Title Color',
		'section'	=> 'divi_ultimate_blog_plugin_blog_post_related_posts',
		'settings'	=> 'divi_ultimate_blog_plugin_blog_post_related_posts_title_color',
	) ) );
	
	$wp_customize->add_setting( 'divi_ultimate_blog_plugin_blog_post_related_posts_number', array(
		'default'       => '3',
		'type'          => 'option',
		'capability'    => 'edit_theme_options',
		'sanitize_callback' => 'absint',
	) );

	$wp_customize->add_control( new ET_Divi_Range_Option ( $wp_customize, 'divi_ultimate_blog_plugin_blog_post_related_posts_number', array(
		'label'	      => 'Number of Related Posts',
		'section'     => 'divi_ultimate_blog_plugin_blog_post_related_posts',
		'settings'	  => 'divi_ultimate_blog_plugin_blog_post_related_posts_number',
		'type'        => 'range',
		'input_attrs' => array(
			'min'  => 1,
			'max'  => 10,
			'step' => 1
		),
	) ) );	
	
}

// Blog Footer choices
function divi_ultimate_blog_plugin_blog_post_footer_choices() {
	$divi_ultimate_blog_plugin_blog_post_footer_choices_array = array();
	$divi_ultimate_blog_plugin_blog_post_footer_choices_array['none'] = 'None';
	$args = array( 'post_type' => 'et_pb_layout', 'numberposts' => -1,
				'meta_query' => array(
					array(
						'key' => '_et_pb_predefined_layout',
						'compare' => 'NOT EXISTS',
					)
				)
			 );
	$divi_ultimate_blog_plugin_blog_post_footers = get_posts( $args );
	if ($divi_ultimate_blog_plugin_blog_post_footers) {
		foreach( $divi_ultimate_blog_plugin_blog_post_footers as $divi_ultimate_blog_plugin_blog_post_footer ) :
			$divi_ultimate_blog_plugin_blog_post_footer_choices_array[$divi_ultimate_blog_plugin_blog_post_footer -> ID] = $divi_ultimate_blog_plugin_blog_post_footer -> post_title;
		endforeach;
	}
	return $divi_ultimate_blog_plugin_blog_post_footer_choices_array;
}
// -------------- Customizer Settings End ----------------

// ----------------- Customizer JS Start -------------------
function divi_ultimate_blog_plugin_customize_controls_js_css() {
	wp_enqueue_script( 'divi-ultimate-blog-customizer-controls-js', plugin_dir_url( __FILE__ ) . 'customizer/divi-ultimate-customizer-controls.js', array( 'jquery' ), DIVI_ULTIMATE_BLOG_PLUGIN_VERSION, true );
	wp_enqueue_style( 'divi-ultimate-blog-customizer-controls-css', plugin_dir_url( __FILE__ ) . 'customizer/divi-ultimate-customizer-controls.css', array(), DIVI_ULTIMATE_BLOG_PLUGIN_VERSION );
}
// ----------------- Customizer JS End -------------------

// ----------------- Customizer Preview JS Start -------------------
function divi_ultimate_blog_plugin_customize_preview_js() {
	wp_enqueue_script( 'divi-ultimate-blog-customizer-js', plugin_dir_url( __FILE__ ) . 'customizer/divi-ultimate-customizer.js', array( 'customize-preview' ), DIVI_ULTIMATE_BLOG_PLUGIN_VERSION, true );
}
// ----------------- Customizer Preivew JS End -------------------

// ------------- Add CSS Class to Body Tag Start -----------------
function divi_ultimate_blog_plugin_add_body_class( $classes = '' ) {
	$divi_ultimate_blog_plugin_blog_post_header_custom = get_option( 'divi_ultimate_blog_plugin_blog_post_header_custom');
	$divi_ultimate_blog_plugin_blog_post_header_style = get_option( 'divi_ultimate_blog_plugin_blog_post_header_style', 'none' );
	$divi_ultimate_blog_plugin_blog_post_navigation_style = get_option( 'divi_ultimate_blog_plugin_blog_post_navigation_style', 'free-blog-post-navigation-hide' );
	$divi_ultimate_blog_plugin_blog_post_related_posts_style = get_option( 'divi_ultimate_blog_plugin_blog_post_related_posts_style', 'free-blog-post-related-posts-hide' );
	$divi_ultimate_blog_plugin_blog_post_header_custom_alignment = get_option( 'divi_ultimate_blog_plugin_blog_post_header_custom_alignment', 'free-blog-post-header-content-center' );
	$divi_ultimate_blog_plugin_blog_post_header_custom_hide = get_option( 'divi_ultimate_blog_plugin_blog_post_header_custom_hide' );
	$divi_ultimate_blog_plugin_blog_post_featured_image_custom = get_option( 'divi_ultimate_blog_plugin_blog_post_featured_image_custom' );
	$divi_ultimate_blog_plugin_blog_post_featured_image_custom_hide = get_option( 'divi_ultimate_blog_plugin_blog_post_featured_image_custom_hide' );
	$divi_ultimate_blog_plugin_blog_post_featured_image_custom_box_shadow = get_option( 'divi_ultimate_blog_plugin_blog_post_featured_image_custom_box_shadow' );
	$divi_ultimate_blog_plugin_blog_post_sidebar_hide = get_option( 'divi_ultimate_blog_plugin_blog_post_sidebar_hide' );
	$divi_ultimate_blog_plugin_blog_post_enable = get_option( 'divi_ultimate_blog_plugin_blog_post_enable' );
	$divi_ultimate_blog_plugin_blog_post_sidebar_mobile_move_to_footer = get_option( 'divi_ultimate_blog_plugin_blog_post_sidebar_mobile_move_to_footer' );
	
	if ($divi_ultimate_blog_plugin_blog_post_sidebar_mobile_move_to_footer) {
		$classes[] = 'free-body-blog-sidebar-move-to-footer';
	}
	
	if ($divi_ultimate_blog_plugin_blog_post_header_style != 'none') {
		$classes[] = $divi_ultimate_blog_plugin_blog_post_header_style;
	}
	if ($divi_ultimate_blog_plugin_blog_post_header_custom_hide) {
		$classes[] = 'free-blog-post-header-featured-hide';
	}
	if ($divi_ultimate_blog_plugin_blog_post_featured_image_custom_hide) {
		$classes[] = 'free-blog-post-featured-image-hide';
	} else {
		$classes[] = 'free-blog-post-featured-image-show';
	}
	if ($divi_ultimate_blog_plugin_blog_post_featured_image_custom_box_shadow) {
		$classes[] = 'free-blog-post-featured-image-box-shadow';
	}
	if ($divi_ultimate_blog_plugin_blog_post_featured_image_custom) {
		$classes[] = 'free-blog-post-featured-image-custom';
	}
	if ($divi_ultimate_blog_plugin_blog_post_related_posts_style == 'free-blog-post-related-posts-hide') {
		$classes[] = 'free-blog-post-related-posts-hide';
	}
	if ($divi_ultimate_blog_plugin_blog_post_header_custom) {
		$classes[] = 'free-blog-post-header-custom';
	}
	if ($divi_ultimate_blog_plugin_blog_post_sidebar_hide) {
		$classes[] = 'free-blog-post-sidebar-hide';
	}
	$classes[] = $divi_ultimate_blog_plugin_blog_post_navigation_style;
	$classes[] = $divi_ultimate_blog_plugin_blog_post_header_custom_alignment;
	
	if ($divi_ultimate_blog_plugin_blog_post_enable) {
		if  ( is_singular('post') ) {
			$classes[] = 'et_pb_pagebuilder_layout';
		}
	}
	
	return $classes;
}
// ------------- Add CSS Class to Body Tag End -----------------

// ------------------ CSS Edit Start ----------------------
function divi_ultimate_blog_plugin_css_edit() {
	$divi_ultimate_blog_plugin_blog_post_related_posts_border_radius = get_option( 'divi_ultimate_blog_plugin_blog_post_related_posts_border_radius', 15 );
	$divi_ultimate_blog_plugin_blog_post_header_custom = get_option( 'divi_ultimate_blog_plugin_blog_post_header_custom');
	$divi_ultimate_blog_plugin_blog_post_header_custom_background_color = get_option( 'divi_ultimate_blog_plugin_blog_post_header_custom_background_color', null );
	$divi_ultimate_blog_plugin_blog_post_header_custom_title_color = get_option( 'divi_ultimate_blog_plugin_blog_post_header_custom_title_color', null );
	$divi_ultimate_blog_plugin_blog_post_header_custom_meta_color = get_option( 'divi_ultimate_blog_plugin_blog_post_header_custom_meta_color', null );
	$divi_ultimate_blog_plugin_blog_post_header_custom_padding_top = get_option( 'divi_ultimate_blog_plugin_blog_post_header_custom_padding_top', 42 );
	$divi_ultimate_blog_plugin_blog_post_header_custom_padding_bottom = get_option( 'divi_ultimate_blog_plugin_blog_post_header_custom_padding_bottom', 100 );
	$divi_ultimate_blog_plugin_blog_post_header_custom_width = get_option( 'divi_ultimate_blog_plugin_blog_post_header_custom_width', 700 );
	$divi_ultimate_blog_plugin_blog_post_header_custom_title_uppercase = get_option( 'divi_ultimate_blog_plugin_blog_post_header_custom_title_uppercase' );
	$divi_ultimate_blog_plugin_blog_post_header_custom_meta_uppercase = get_option( 'divi_ultimate_blog_plugin_blog_post_header_custom_meta_uppercase' );
	$divi_ultimate_blog_plugin_blog_post_header_custom_blur = get_option( 'divi_ultimate_blog_plugin_blog_post_header_custom_blur', 0 );
	$divi_ultimate_blog_plugin_blog_post_header_custom_scale = get_option( 'divi_ultimate_blog_plugin_blog_post_header_custom_scale', 0 );
	$divi_ultimate_blog_plugin_blog_post_header_custom_title_size = get_option( 'divi_ultimate_blog_plugin_blog_post_header_custom_title_size', 38 );
	$divi_ultimate_blog_plugin_blog_post_header_custom_title_weight = get_option( 'divi_ultimate_blog_plugin_blog_post_header_custom_title_weight', 700 );
	$divi_ultimate_blog_plugin_blog_post_featured_image_custom = get_option( 'divi_ultimate_blog_plugin_blog_post_featured_image_custom' );
	$divi_ultimate_blog_plugin_blog_post_featured_image_custom_offset = get_option( 'divi_ultimate_blog_plugin_blog_post_featured_image_custom_offset', 0 );
	$divi_ultimate_blog_plugin_blog_post_featured_image_custom_border_width = get_option( 'divi_ultimate_blog_plugin_blog_post_featured_image_custom_border_width', 0 );
	$divi_ultimate_blog_plugin_blog_post_related_posts_title_color = get_option( 'divi_ultimate_blog_plugin_blog_post_related_posts_title_color', null );
	$divi_ultimate_blog_plugin_blog_post_related_posts_background_color = get_option( 'divi_ultimate_blog_plugin_blog_post_related_posts_background_color', null );
	
	?>
	<style type="text/css"> <?php
		
		// Related posts border radius
		if(!empty($divi_ultimate_blog_plugin_blog_post_related_posts_border_radius)) { ?>
			.free-du-blog-1 .free-blog-related-posts .et_pb_post {
				border-radius: <?php echo $divi_ultimate_blog_plugin_blog_post_related_posts_border_radius; ?>px!important;
			}
			<?php
		}
		
		// Blog header custom
		if(!empty($divi_ultimate_blog_plugin_blog_post_header_custom_background_color)) { ?>
			.free-blog-post-header-custom .free-du-blog-1 .free-blog-post-header {
				background: <?php echo $divi_ultimate_blog_plugin_blog_post_header_custom_background_color; ?>!important;
			}
			<?php
		}
		
		if(!empty($divi_ultimate_blog_plugin_blog_post_header_custom_title_color)) { ?>
			.free-blog-post-header-custom .free-du-blog-1 .free-blog-post-header-content .entry-title {
				color: <?php echo $divi_ultimate_blog_plugin_blog_post_header_custom_title_color; ?>!important;
			}
			<?php
		}
		
		if(!empty($divi_ultimate_blog_plugin_blog_post_header_custom_meta_color)) { ?>
			.free-blog-post-header-custom #main-content.free-du-blog-1 .free-blog-post-header-content .post-meta, .free-blog-post-header-custom #main-content.free-du-blog-1 .free-blog-post-header-content .post-meta a {
				color: <?php echo $divi_ultimate_blog_plugin_blog_post_header_custom_meta_color; ?>!important;
			}
			<?php
		}
		
		?>
		
		.free-blog-post-header-custom .free-du-blog-1 .free-blog-post-header-content {
			padding-top: <?php echo $divi_ultimate_blog_plugin_blog_post_header_custom_padding_top; ?>px!important;
			padding-bottom: <?php echo $divi_ultimate_blog_plugin_blog_post_header_custom_padding_bottom; ?>px!important;
			max-width: <?php echo $divi_ultimate_blog_plugin_blog_post_header_custom_width; ?>px!important;
		}
		.free-blog-post-header-custom .free-du-blog-1 .free-blog-post-header-content .entry-title {
			text-transform: <?php if($divi_ultimate_blog_plugin_blog_post_header_custom_title_uppercase) { ?>uppercase<?php } else { ?>none<?php } ?>!important;
			font-weight: <?php echo $divi_ultimate_blog_plugin_blog_post_header_custom_title_weight; ?>!important;
		}
		.free-blog-post-header-custom .free-du-blog-1 .free-blog-post-header-content .post-meta {
			text-transform: <?php if($divi_ultimate_blog_plugin_blog_post_header_custom_meta_uppercase) { ?>uppercase<?php } else { ?>none<?php } ?>!important;
		}
		.free-blog-post-header-custom .free-du-blog-1 .free-blog-post-header-featured {
			filter: blur(<?php echo $divi_ultimate_blog_plugin_blog_post_header_custom_blur; ?>px)!important;
			-webkit-filter: blur(<?php echo $divi_ultimate_blog_plugin_blog_post_header_custom_blur; ?>px)!important;
		}
		.free-blog-post-header-custom .free-du-blog-1 .free-blog-post-header-featured-scale {
			transform: scale(1.<?php echo $divi_ultimate_blog_plugin_blog_post_header_custom_scale; ?>)!important;
		}
		
		@media screen and (min-width: 622px) {
			.free-blog-post-header-custom .free-du-blog-1 .free-blog-post-header-content .entry-title {
				font-size: <?php echo $divi_ultimate_blog_plugin_blog_post_header_custom_title_size; ?>px!important;
			}
		}
		
		
		<?php				
		// Blog featured image  ?>
		.free-blog-post-featured-image-custom .free-du-blog-1 .free-blog-post-featured>* {
			margin-top: -<?php echo $divi_ultimate_blog_plugin_blog_post_featured_image_custom_offset; ?>px!important;
			border: <?php echo $divi_ultimate_blog_plugin_blog_post_featured_image_custom_border_width; ?>px solid #FFF!important;
		}
		
		<?php
		// Blog related posts background color
		if(!empty($divi_ultimate_blog_plugin_blog_post_related_posts_background_color)) { ?>
			.free-du-blog-1 .free-blog-related-posts-background-color {
				background: <?php echo $divi_ultimate_blog_plugin_blog_post_related_posts_background_color; ?>!important;
			}
			<?php
		}
						
		// Blog related posts title color
		if(!empty($divi_ultimate_blog_plugin_blog_post_related_posts_title_color)) { ?>
			.free-du-blog-1 .free-blog-related-posts .free-blog-related-posts-title h2 {
				color: <?php echo $divi_ultimate_blog_plugin_blog_post_related_posts_title_color; ?>!important;
			}
			<?php
		} ?>
		
	</style> <?php
}
// ------------------ CSS Edit End ----------------------

// -------------- Post Meta Override Start ----------------
if ( ! function_exists( 'et_pb_postinfo_meta' ) ) {
	function et_pb_postinfo_meta( $postinfo, $date_format, $comment_zero, $comment_one, $comment_more ){
		$postinfo_meta = '';

		if ( in_array( 'author', $postinfo ) )
			$postinfo_meta .= ' ' . ' <span class="free-post-meta-author author vcard">' . esc_html__( 'by', 'et_builder' ) . ' ' . et_pb_get_the_author_posts_link() . '</span>';

		if ( in_array( 'date', $postinfo ) ) {
			if ( in_array( 'author', $postinfo ) ) $postinfo_meta .= ' | ';
			$postinfo_meta .= '<span class="free-post-meta-date published">' . esc_html( get_the_time( wp_unslash( $date_format ) ) ) . '</span>';
		}

		if ( in_array( 'categories', $postinfo ) ) {
			$categories_list = get_the_category_list(', ');

			// do not output anything if no categories retrieved
			if ( '' !== $categories_list ) {
				if ( in_array( 'author', $postinfo ) || in_array( 'date', $postinfo ) )	$postinfo_meta .= ' | ';

				$postinfo_meta .= '<span class="free-post-meta-category">' . $categories_list . '</span>';
			}
		}

		if ( in_array( 'comments', $postinfo ) ){
			if ( in_array( 'author', $postinfo ) || in_array( 'date', $postinfo ) || in_array( 'categories', $postinfo ) ) $postinfo_meta .= ' | ';
			$postinfo_meta .= et_pb_get_comments_popup_link( $comment_zero, $comment_one, $comment_more );
		}

		return $postinfo_meta;
	}
}
// -------------- Post Meta Override End ----------------

?>